package com.ejie.ab18a.utilidades;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.List;
import java.util.Properties;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import net.sf.saxon.TransformerFactoryImpl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.ab18a.envioBoletin.Ab18aEnvioBoletines;
import com.ejie.ab18a.log.Ab18aLog;

/**
 * The Class Y46jUtils.
 * 
 * @author XXXX
 */
public class Ab18aUtils {

	private static final Logger logger = LoggerFactory.getLogger(Ab18aUtils.class);

	/** The Constant valor_50. */
	// private static final Integer valor_50 = 50;

	/** The Constant valor_35. */
	// private static final Integer valor_35 = 35;

	/**
	 * Instantiates a new y46j utils.
	 */
	protected Ab18aUtils() {

	}

	/**
	 * Generar big decimal.
	 * 
	 * @param valor
	 *            the valor
	 * @return the big decimal
	 */
	// public static BigDecimal generarBigDecimal(String valor) {
	//
	// if (valor != null && !"".equals(valor)) {
	// if (valor.indexOf(",") != -1)
	// {
	// valor = valor.replace(",", ".");
	// }
	// return new BigDecimal(valor);
	// } else {
	// return BigDecimal.ZERO;
	// }
	// }

	/**
	 * Gets the object.
	 * 
	 * @param nombreClase
	 *            the nombre clase
	 * @return the object
	 */
	// Metodo para la creacion de objetos sin hacer el new dentro del for
	// public static Object getObject(String nombreClase) {
	// String nombre_metodo = "getObject";
	//
	// Class<?> clase = null;
	// Object obj = null;
	// try {
	// clase = Class.forName(nombreClase);
	// obj = clase.newInstance();
	// } catch (InstantiationException e) {
	// Y46jLog.error(Y46jProceso.class.getName(), nombre_metodo,
	// "No ha sido posible crear un objeto de tipo '"
	// + nombreClase + "'. Error: " + e.getMessage(), 1);
	// } catch (IllegalAccessException e) {
	// Y46jLog.error(Y46jProceso.class.getName(), nombre_metodo,
	// "No ha sido posible crear un objeto de tipo '"
	// + nombreClase + "'. Error: " + e.getMessage(), 1);
	// } catch (ClassNotFoundException e) {
	// Y46jLog.error(Y46jProceso.class.getName(), nombre_metodo,
	// "No ha sido posible crear un objeto de tipo '"
	// + nombreClase + "'. Error: " + e.getMessage(), 1);
	// }
	//
	// if (null == obj) {
	// Y46jLog.error(Y46jProceso.class.getName(), nombre_metodo,
	// "No ha sido posible crear un objeto de tipo '"
	// + nombreClase + "'. Se devuelve 'null'", 1);
	// }
	//
	// return obj;
	// }

	/**
	 * Checks if is numeric.
	 * 
	 * @param cadena
	 *            the cadena
	 * @return true, if is numeric
	 */
	// public static boolean isNumeric(String cadena){
	// try {
	// Integer.parseInt(cadena);
	// return true;
	// } catch (NumberFormatException nfe){
	// return false;
	// }
	// }
	//
	// public static boolean isNumericBigDecimal(String cadena){
	// try{
	// new BigDecimal(cadena);
	// return true;
	// }catch (NumberFormatException nfe){
	// return false;
	// }
	// }

	/**
	 * Obtener property.
	 * 
	 * @param propiedad
	 *            the propiedad
	 * @return the string
	 * @throws RuntimeException
	 *             the runtime exception
	 */
	public static String getProperty(String propiedad) throws RuntimeException {
		String strResultado = "";
		FileInputStream f = null;
		try {
			// f = new
			// FileInputStream("/config/dominio_desa/y46j/y46jbatch.properties");
			f = new FileInputStream("/config/ab18a/y46jbatch.properties");
		} catch (Exception e) {
			throw new RuntimeException("obtenerProperty(). No se ha encontrado el fichero y46j/y46jbatch.properties.");
		}
		if (null != f) {
			// Existe el fichero de propiedades
			Properties prop = new Properties();
			try {
				prop.load(f);

				// Obtener propiedad
				strResultado = prop.getProperty(propiedad);
			} catch (IOException e) {
				throw new RuntimeException("obtenerProperty(). No es posible obtener la propiedad " + propiedad);
			}
		}
		return strResultado;
	}

	/**
	 * Method 'notNullAndNotEmpty'. Metodo que devuelve 'false' si el valor
	 * pasado es null o vacio, en caso contrario devuelve 'true'.
	 * 
	 * @param campo
	 *            the campo
	 * @return boolean
	 */
	public static boolean notNullAndNotEmpty(final Object campo) {

		if (campo == null) {
			return false;
		} else {
			if (campo instanceof String && ((String) campo).trim().length() == 0) {
				return false;
			} else if (campo instanceof Long && ((Long) campo) == 0) {
				return false;
			} else if (campo instanceof Integer && ((Integer) campo) == 0) {
				return false;
			} else if (campo instanceof BigInteger && ((BigInteger) campo).intValue() == 0) {
				return false;
			} else if (campo instanceof List<?> && (((List<?>) campo).size()) == 0) {
				return false;
			}
		}
		return true;
	}

	public static String transformarXSLT(InputStream xml, String rutaXSLT) throws TransformerException {

		Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), "transformarXSLT", "transformarXSLT(); INICIO; " + rutaXSLT, 1);

		// Use the factory to create a template containing the xsl file
		StringBuffer resultado = new StringBuffer();

		try {
			File schema = new File(rutaXSLT);
			if (schema.isFile()) {
				Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), "transformarXSLT", "Encontrado esquema", 1);
			}

			// Create transformer factory
			TransformerFactory factory = new TransformerFactoryImpl();
			Templates template = factory.newTemplates(new StreamSource(schema));

			// Use the template to create a transformer
			Transformer xformer = template.newTransformer();

			// Prepare the input and output files
			Source source = new StreamSource(xml);

			StringWriter outWriter = new StringWriter();

			Result result = new StreamResult(outWriter);

			// Apply the xsl file to the source file and write the result
			// to the output file
			xformer.transform(source, result);

			resultado.append(outWriter.getBuffer());

		} catch (TransformerConfigurationException e) {
			Ab18aLog.error(e.getClass().getName(), "Error configuración en transformer: Ruta XSLT: " + rutaXSLT, e.getMessage(), 1);
			throw e;
		} catch (TransformerException e) {
			Ab18aLog.error(e.getClass().getName(), "No se ha encontrado la plantilla", e.getMessage(), 1);
			throw e;
		}
		Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), "transformarXSLT", "transformarXSLT(); FIN; " + resultado, 1);

		return resultado.toString();
	}

	// /**
	// * Gets the fecha.
	// *
	// * @param fecha
	// * the fecha
	// * @param idioma
	// * the idioma
	// * @return the fecha
	// * @throws Exception
	// * the exception
	// */
	// public static Date getFecha(String fecha, String idioma) throws Exception
	// {
	// if (!Ab18aUtils.notNullAndNotEmpty(fecha)) {
	// return null;
	// }
	// return Ab18aUtils.doRecuperaFormatoFechaPorIdioma(idioma).parse(fecha);
	// }
	//
	//
	// /**
	// * Do recupera formato fecha por idioma.
	// *
	// * @param idioma
	// * the idioma
	// * @return the simple date format
	// */
	// public static SimpleDateFormat doRecuperaFormatoFechaPorIdioma(String
	// idioma) {
	// SimpleDateFormat fecha = null;
	// if (idioma.equals(Y46jConstantes.IDIOMA_ES)) {
	// // castelano
	// fecha = new SimpleDateFormat(
	// Y46jConstantes.CTE_MASCARA_FECHA_DIA_MES_ANO);
	// } else {
	// // euskera
	// fecha = new SimpleDateFormat(
	// Y46jConstantes.CTE_MASCARA_FECHA_ANO_MES_DIA);
	// }
	// return fecha;
	// }
	//
	//
	// /**
	// * Gets the time.
	// *
	// * @param formato the formato
	// * @param fecha the fecha
	// * @return the time
	// */
	// public static String getTime(String formato, Date fecha) {
	// if (fecha != null) {
	// Calendar cal = Calendar.getInstance();
	// cal.setTime(fecha);
	// if (cal.get(Calendar.DATE) == Y46jConstantes.DIA_31
	// && cal.get(Calendar.MONTH) == Calendar.DECEMBER
	// && cal.get(Calendar.YEAR) == Y46jConstantes.ANIO_9999) {
	// return "";
	// } else {
	// SimpleDateFormat formatFecha = new SimpleDateFormat(formato);
	// return formatFecha.format(fecha);
	// }
	// }
	// return "";
	// }
	//
	// /**
	// * Generar excel listado informes.
	// *
	// * @param fileTitle the file title
	// * @param datosExcel the datos excel
	// * @param idioma the idioma
	// * @return the hSSF workbook
	// * @throws Exception the exception
	// */
	// public static HSSFWorkbook generarExcelListadoInformes(String fileTitle,
	// HashMap<Object, Object> datosExcel,
	// String idioma,Integer tipoIndicador)throws Exception {
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "INICIO generarExcelListadoInformes", 1);
	//
	// Y46jRecursosManager manager = new Y46jRecursosManager();
	//
	// HSSFWorkbook libro = new HSSFWorkbook();
	// HSSFSheet hojaFormalizados = null;
	// HSSFSheet hojaDesistidos = null;
	// HSSFSheet hojaEjecucion =null;
	//
	// if(idioma.equalsIgnoreCase(Y46jConstantes.IDIOMA_ES)){
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// hojaFormalizados = libro.createSheet(manager
	// .getMessage("registro.contratosNC.pdf.formalizados"));
	// hojaDesistidos = libro.createSheet(manager.getMessage(
	// "registro.contratosNC.pdf.desisitidos"));
	// }
	// hojaEjecucion = libro.createSheet(manager.getMessage(
	// "registro.contratosNC.pdf.incidenciasEjecucion"));
	//
	// }else{
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// hojaFormalizados = libro.createSheet(manager
	// .getMessage("registro.contratosNC.pdf.formalizados_eu"));
	// hojaDesistidos = libro.createSheet(manager.getMessage(
	// "registro.contratosNC.pdf.desisitidos_eu"));
	// }
	// hojaEjecucion = libro.createSheet(manager.getMessage(
	// "registro.contratosNC.pdf.incidenciasEjecucion_eu"));
	//
	// }
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de establecer margenes de pagina",
	// 1);
	//
	// // Establecer los margenes de pagina
	// HSSFPrintSetup ps = null;
	// HSSFPrintSetup psD = null;
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// ps = hojaFormalizados.getPrintSetup();
	// psD = hojaDesistidos.getPrintSetup();
	// }
	// HSSFPrintSetup psE = hojaEjecucion.getPrintSetup();
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// ps.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// ps.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hojaFormalizados.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hojaFormalizados.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaFormalizados.setMargin(HSSFSheet.LeftMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaFormalizados.setMargin(HSSFSheet.RightMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	//
	// psD.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// psD.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hojaDesistidos.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hojaDesistidos.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaDesistidos.setMargin(HSSFSheet.LeftMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaDesistidos.setMargin(HSSFSheet.RightMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// }
	//
	// psE.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// psE.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hojaEjecucion.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hojaEjecucion.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaEjecucion.setMargin(HSSFSheet.LeftMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaEjecucion.setMargin(HSSFSheet.RightMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	//
	// // Establecer la cebecera y el pie de pagina
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// HSSFHeader headerFormalizados = hojaFormalizados.getHeader();
	// headerFormalizados.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footerFormalizados = hojaFormalizados.getFooter();
	// footerFormalizados.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	//
	// HSSFHeader headerDesistidos = hojaDesistidos.getHeader();
	// headerDesistidos.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footerDesistidos = hojaDesistidos.getFooter();
	// footerDesistidos.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	// }
	// HSSFHeader headerEjecucion = hojaEjecucion.getHeader();
	// headerEjecucion.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footerEjecucion = hojaEjecucion.getFooter();
	// footerEjecucion.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	//
	// // Definicion de fuentes para las celdas
	// HSSFFont fuente = libro.createFont();
	// fuente.setFontHeightInPoints((short) Y46jConstantes.NUMERO_10);
	// fuente.setFontName("Arial");
	//
	// HSSFFont fuenteTitulos = libro.createFont();
	// fuenteTitulos.setFontHeightInPoints((short) Y46jConstantes.NUMERO_11);
	// fuenteTitulos.setColor(HSSFColor.BLACK.index);
	// fuenteTitulos.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD); // make it bold
	// fuenteTitulos.setFontName("Calibri");
	//
	// HSSFFont fuenteTitulosPrincipales = libro.createFont();
	// fuenteTitulosPrincipales
	// .setFontHeightInPoints((short) Y46jConstantes.NUMERO_18);
	// fuenteTitulosPrincipales.setColor(HSSFColor.BLACK.index);
	// fuenteTitulosPrincipales.setFontName("Calibri");
	//
	// // Definicion de estilo para celdas de fila de titulos NO PRINCIPALES
	// HSSFCellStyle estiloTitulosGenerales = libro.createCellStyle();
	// estiloTitulosGenerales
	// .setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index);
	// estiloTitulosGenerales.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosGenerales.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosGenerales.setFont(fuenteTitulos);
	// estiloTitulosGenerales.setWrapText(true);
	//
	// HSSFCellStyle estiloTitulosLicitacion = libro.createCellStyle();
	// estiloTitulosLicitacion
	// .setFillForegroundColor(HSSFColor.SKY_BLUE.index);
	// estiloTitulosLicitacion.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosLicitacion.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosLicitacion.setFont(fuenteTitulos);
	// estiloTitulosLicitacion.setWrapText(true);
	//
	// HSSFCellStyle estiloTitulosAdjudicacion = libro.createCellStyle();
	// estiloTitulosAdjudicacion
	// .setFillForegroundColor(HSSFColor.ORANGE.index);
	// estiloTitulosAdjudicacion
	// .setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosAdjudicacion.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosAdjudicacion.setFont(fuenteTitulos);
	// estiloTitulosAdjudicacion.setWrapText(true);
	//
	// HSSFCellStyle estiloTitulosAccesoPublico = libro.createCellStyle();
	// estiloTitulosAccesoPublico
	// .setFillForegroundColor(HSSFColor.BRIGHT_GREEN.index);
	// estiloTitulosAccesoPublico
	// .setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosAccesoPublico.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosAccesoPublico.setFont(fuenteTitulos);
	// estiloTitulosAccesoPublico.setWrapText(true);
	//
	// HSSFCellStyle estiloTitulosSujeto = libro.createCellStyle();
	// estiloTitulosSujeto.setFillForegroundColor(HSSFColor.LAVENDER.index);
	// estiloTitulosSujeto.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosSujeto.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosSujeto.setFont(fuenteTitulos);
	// estiloTitulosSujeto.setWrapText(true);
	//
	// // Definicion de estilo para celdas de fila de titulos PRINCIPALES
	// HSSFCellStyle estiloTituloGeneral = libro.createCellStyle();
	// estiloTituloGeneral
	// .setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
	// estiloTituloGeneral.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloGeneral.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloGeneral.setFont(fuenteTitulosPrincipales);
	//
	// HSSFCellStyle estiloTituloLicitacion = libro.createCellStyle();
	// estiloTituloLicitacion
	// .setFillForegroundColor(HSSFColor.PALE_BLUE.index);
	// estiloTituloLicitacion.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloLicitacion.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloLicitacion.setFont(fuenteTitulosPrincipales);
	//
	// HSSFCellStyle estiloTituloAdjudicacion = libro.createCellStyle();
	// estiloTituloAdjudicacion
	// .setFillForegroundColor(HSSFColor.LIGHT_ORANGE.index);
	// estiloTituloAdjudicacion.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloAdjudicacion.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloAdjudicacion.setFont(fuenteTitulosPrincipales);
	//
	// HSSFCellStyle estiloTituloAccesoPublico = libro.createCellStyle();
	// estiloTituloAccesoPublico.setFillForegroundColor(HSSFColor.LIME.index);
	// estiloTituloAccesoPublico
	// .setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloAccesoPublico.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloAccesoPublico.setFont(fuenteTitulosPrincipales);
	//
	// HSSFCellStyle estiloTituloSujeto = libro.createCellStyle();
	// estiloTituloSujeto.setFillForegroundColor(HSSFColor.VIOLET.index);
	// estiloTituloSujeto.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloSujeto.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloSujeto.setFont(fuenteTitulosPrincipales);
	//
	// // Definicion de estilos para celdas de filas
	// HSSFCellStyle estiloCelda = libro.createCellStyle();
	// estiloCelda.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloCelda.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloCelda.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloCelda.setWrapText(true);
	// estiloCelda.setFont(fuente);
	//
	// HSSFCellStyle estiloFila = libro.createCellStyle();
	// estiloFila.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloFila.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloFila.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// // estiloFila.setWrapText(true);
	// estiloFila.setFont(fuente);
	//
	// HSSFCellStyle estiloBordeInferior = libro.createCellStyle();
	// estiloBordeInferior.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloBordeInferior.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloBordeInferior.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	// estiloBordeInferior.setWrapText(true);
	// estiloBordeInferior.setFont(fuente);
	//
	// // Estilo de fuente BOLD
	// HSSFCellStyle estiloBold = libro.createCellStyle();
	// HSSFFont font = libro.createFont();
	// font.setFontHeightInPoints((short) Y46jConstantes.NUMERO_8);
	// font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	// estiloBold.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// font.setFontName("Verdana");
	// estiloBold.setFont(font);
	// estiloBold.setWrapText(true);
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes",
	// "Antes de recorrer la lista de los titulos principales", 1);
	//
	// // Recorremos la lista de los titulos principales
	// Collection<Object> colTitulosPrincipales = (Collection<Object>)
	// datosExcel
	// .get("listaTitulosPrincipales");
	// Map<Object, Object> listaTitulosPrincipalesMap = new HashMap<Object,
	// Object>();
	//
	// Iterator<Object> itTitulos = colTitulosPrincipales.iterator();
	// while (itTitulos.hasNext()) {
	// listaTitulosPrincipalesMap = (Map<Object, Object>) itTitulos.next();
	// }
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de crearCells", 1);
	//
	// Ab18aUtils.crearCells(hojaFormalizados, hojaDesistidos, hojaEjecucion,
	// listaTitulosPrincipalesMap, estiloTituloGeneral,
	// estiloTituloLicitacion, estiloTituloAdjudicacion,
	// estiloTituloAccesoPublico, estiloTituloSujeto,tipoIndicador);
	//
	// Map<Object, Object> columnsMaxSizeMap = new HashMap<Object, Object>();
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de obtenerDatosFormalizados", 1);
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// Ab18aUtils.obtenerDatosFormalizados(datosExcel, hojaFormalizados,
	// estiloTitulosGenerales, estiloTitulosLicitacion,
	// estiloTitulosAccesoPublico, estiloTitulosAdjudicacion,
	// estiloCelda, estiloFila, columnsMaxSizeMap);
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de obtenerDatosDesistidos", 1);
	//
	// Ab18aUtils.obtenerDatosDesistidos(datosExcel, hojaDesistidos,
	// estiloTitulosGenerales, estiloTitulosLicitacion,
	// estiloTitulosAccesoPublico, estiloCelda, estiloFila,
	// columnsMaxSizeMap);
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de obtenerDatosEjecucion", 1);
	// }
	// Ab18aUtils.obtenerDatosEjecucion(datosExcel, hojaEjecucion,
	// estiloTitulosGenerales, estiloTitulosLicitacion,
	// estiloTitulosAccesoPublico, estiloTitulosSujeto, estiloCelda,
	// estiloFila, columnsMaxSizeMap);
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "FIN generarExcelListadoInformes", 1);
	//
	//
	// //libro
	// return libro;
	// }
	//
	//
	//
	// /**
	// * Generar excel listado informes.
	// *
	// * @param fileTitle the file title
	// * @param datosExcel the datos excel
	// * @param idioma the idioma
	// * @return the hSSF workbook
	// * @throws Exception the exception
	// */
	// public static HSSFWorkbook generarExcelListadoInformesIndicadores(String
	// fileTitle,
	// HashMap<Object, Object> datosExcel,
	// String idioma,Integer tipoIndicador)throws Exception {
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "INICIO generarExcelListadoInformes", 1);
	//
	// Y46jRecursosManager manager = new Y46jRecursosManager();
	//
	// HSSFWorkbook libro = new HSSFWorkbook();
	// HSSFSheet hojaFormalizados = null;
	// HSSFSheet hojaDesistidos = null;
	// HSSFSheet hojaEjecucion =null;
	//
	// if(idioma.equalsIgnoreCase(Y46jConstantes.IDIOMA_ES)){
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// hojaFormalizados = libro.createSheet(manager
	// .getMessage("registro.contratosNC.pdf.formalizados"));
	// hojaDesistidos = libro.createSheet(manager.getMessage(
	// "registro.contratosNC.pdf.desisitidos"));
	// }
	// hojaEjecucion = libro.createSheet(manager.getMessage(
	// "registro.contratosNC.pdf.incidenciasEjecucion"));
	//
	// }else{
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// hojaFormalizados = libro.createSheet(manager
	// .getMessage("registro.contratosNC.pdf.formalizados_eu"));
	// hojaDesistidos = libro.createSheet(manager.getMessage(
	// "registro.contratosNC.pdf.desisitidos_eu"));
	// }
	// hojaEjecucion = libro.createSheet(manager.getMessage(
	// "registro.contratosNC.pdf.incidenciasEjecucion_eu"));
	//
	// }
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de establecer margenes de pagina",
	// 1);
	//
	// // Establecer los margenes de pagina
	// HSSFPrintSetup ps = null;
	// HSSFPrintSetup psD = null;
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// ps = hojaFormalizados.getPrintSetup();
	// psD = hojaDesistidos.getPrintSetup();
	// }
	// HSSFPrintSetup psE = hojaEjecucion.getPrintSetup();
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// ps.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// ps.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hojaFormalizados.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hojaFormalizados.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaFormalizados.setMargin(HSSFSheet.LeftMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaFormalizados.setMargin(HSSFSheet.RightMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	//
	// psD.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// psD.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hojaDesistidos.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hojaDesistidos.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaDesistidos.setMargin(HSSFSheet.LeftMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaDesistidos.setMargin(HSSFSheet.RightMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// }
	//
	// psE.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// psE.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hojaEjecucion.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hojaEjecucion.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaEjecucion.setMargin(HSSFSheet.LeftMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaEjecucion.setMargin(HSSFSheet.RightMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	//
	// // Establecer la cebecera y el pie de pagina
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// HSSFHeader headerFormalizados = hojaFormalizados.getHeader();
	// headerFormalizados.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footerFormalizados = hojaFormalizados.getFooter();
	// footerFormalizados.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	//
	// HSSFHeader headerDesistidos = hojaDesistidos.getHeader();
	// headerDesistidos.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footerDesistidos = hojaDesistidos.getFooter();
	// footerDesistidos.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	// }
	// HSSFHeader headerEjecucion = hojaEjecucion.getHeader();
	// headerEjecucion.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footerEjecucion = hojaEjecucion.getFooter();
	// footerEjecucion.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	//
	// // Definicion de fuentes para las celdas
	// HSSFFont fuente = libro.createFont();
	// fuente.setFontHeightInPoints((short) Y46jConstantes.NUMERO_10);
	// fuente.setFontName("Arial");
	//
	// HSSFFont fuenteTitulos = libro.createFont();
	// fuenteTitulos.setFontHeightInPoints((short) Y46jConstantes.NUMERO_11);
	// fuenteTitulos.setColor(HSSFColor.BLACK.index);
	// fuenteTitulos.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD); // make it bold
	// fuenteTitulos.setFontName("Calibri");
	//
	// HSSFFont fuenteTitulosPrincipales = libro.createFont();
	// fuenteTitulosPrincipales
	// .setFontHeightInPoints((short) Y46jConstantes.NUMERO_18);
	// fuenteTitulosPrincipales.setColor(HSSFColor.BLACK.index);
	// fuenteTitulosPrincipales.setFontName("Calibri");
	//
	// // Definicion de estilo para celdas de fila de titulos NO PRINCIPALES
	// HSSFCellStyle estiloTitulosGenerales = libro.createCellStyle();
	// estiloTitulosGenerales
	// .setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index);
	// estiloTitulosGenerales.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosGenerales.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosGenerales.setFont(fuenteTitulos);
	// estiloTitulosGenerales.setWrapText(true);
	//
	// HSSFCellStyle estiloTitulosLicitacion = libro.createCellStyle();
	// estiloTitulosLicitacion
	// .setFillForegroundColor(HSSFColor.SKY_BLUE.index);
	// estiloTitulosLicitacion.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosLicitacion.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosLicitacion.setFont(fuenteTitulos);
	// estiloTitulosLicitacion.setWrapText(true);
	//
	// HSSFCellStyle estiloTitulosAdjudicacion = libro.createCellStyle();
	// estiloTitulosAdjudicacion
	// .setFillForegroundColor(HSSFColor.ORANGE.index);
	// estiloTitulosAdjudicacion
	// .setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosAdjudicacion.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosAdjudicacion.setFont(fuenteTitulos);
	// estiloTitulosAdjudicacion.setWrapText(true);
	//
	// HSSFCellStyle estiloTitulosAccesoPublico = libro.createCellStyle();
	// estiloTitulosAccesoPublico
	// .setFillForegroundColor(HSSFColor.BRIGHT_GREEN.index);
	// estiloTitulosAccesoPublico
	// .setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosAccesoPublico.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosAccesoPublico.setFont(fuenteTitulos);
	// estiloTitulosAccesoPublico.setWrapText(true);
	//
	// HSSFCellStyle estiloTitulosSujeto = libro.createCellStyle();
	// estiloTitulosSujeto.setFillForegroundColor(HSSFColor.LAVENDER.index);
	// estiloTitulosSujeto.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosSujeto.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosSujeto.setFont(fuenteTitulos);
	// estiloTitulosSujeto.setWrapText(true);
	//
	// // Definicion de estilo para celdas de fila de titulos PRINCIPALES
	// HSSFCellStyle estiloTituloGeneral = libro.createCellStyle();
	// estiloTituloGeneral
	// .setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
	// estiloTituloGeneral.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloGeneral.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloGeneral.setFont(fuenteTitulosPrincipales);
	//
	// HSSFCellStyle estiloTituloLicitacion = libro.createCellStyle();
	// estiloTituloLicitacion
	// .setFillForegroundColor(HSSFColor.PALE_BLUE.index);
	// estiloTituloLicitacion.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloLicitacion.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloLicitacion.setFont(fuenteTitulosPrincipales);
	//
	// HSSFCellStyle estiloTituloAdjudicacion = libro.createCellStyle();
	// estiloTituloAdjudicacion
	// .setFillForegroundColor(HSSFColor.LIGHT_ORANGE.index);
	// estiloTituloAdjudicacion.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloAdjudicacion.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloAdjudicacion.setFont(fuenteTitulosPrincipales);
	//
	// HSSFCellStyle estiloTituloAccesoPublico = libro.createCellStyle();
	// estiloTituloAccesoPublico.setFillForegroundColor(HSSFColor.LIME.index);
	// estiloTituloAccesoPublico
	// .setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloAccesoPublico.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloAccesoPublico.setFont(fuenteTitulosPrincipales);
	//
	// HSSFCellStyle estiloTituloSujeto = libro.createCellStyle();
	// estiloTituloSujeto.setFillForegroundColor(HSSFColor.VIOLET.index);
	// estiloTituloSujeto.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloSujeto.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloSujeto.setFont(fuenteTitulosPrincipales);
	//
	// // Definicion de estilos para celdas de filas
	// HSSFCellStyle estiloCelda = libro.createCellStyle();
	// estiloCelda.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloCelda.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloCelda.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloCelda.setWrapText(true);
	// estiloCelda.setFont(fuente);
	//
	// HSSFCellStyle estiloFila = libro.createCellStyle();
	// estiloFila.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloFila.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloFila.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// // estiloFila.setWrapText(true);
	// estiloFila.setFont(fuente);
	//
	// HSSFCellStyle estiloBordeInferior = libro.createCellStyle();
	// estiloBordeInferior.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloBordeInferior.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloBordeInferior.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	// estiloBordeInferior.setWrapText(true);
	// estiloBordeInferior.setFont(fuente);
	//
	// // Estilo de fuente BOLD
	// HSSFCellStyle estiloBold = libro.createCellStyle();
	// HSSFFont font = libro.createFont();
	// font.setFontHeightInPoints((short) Y46jConstantes.NUMERO_8);
	// font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	// estiloBold.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// font.setFontName("Verdana");
	// estiloBold.setFont(font);
	// estiloBold.setWrapText(true);
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes",
	// "Antes de recorrer la lista de los titulos principales", 1);
	//
	// // Recorremos la lista de los titulos principales
	// Collection<Object> colTitulosPrincipales = (Collection<Object>)
	// datosExcel
	// .get("listaTitulosPrincipales");
	// Map<Object, Object> listaTitulosPrincipalesMap = new HashMap<Object,
	// Object>();
	//
	// Iterator<Object> itTitulos = colTitulosPrincipales.iterator();
	// while (itTitulos.hasNext()) {
	// listaTitulosPrincipalesMap = (Map<Object, Object>) itTitulos.next();
	// }
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de crearCells", 1);
	//
	// Ab18aUtils.crearCellsIndicadores(hojaFormalizados, hojaDesistidos,
	// hojaEjecucion,
	// listaTitulosPrincipalesMap, estiloTituloGeneral,
	// estiloTituloLicitacion, estiloTituloAdjudicacion,
	// estiloTituloAccesoPublico, estiloTituloSujeto,tipoIndicador);
	//
	// Map<Object, Object> columnsMaxSizeMap = new HashMap<Object, Object>();
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de obtenerDatosFormalizados", 1);
	// if(tipoIndicador==null || (tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66)){
	// Ab18aUtils.obtenerDatosFormalizados(datosExcel, hojaFormalizados,
	// estiloTitulosGenerales, estiloTitulosLicitacion,
	// estiloTitulosAccesoPublico, estiloTitulosAdjudicacion,
	// estiloCelda, estiloFila, columnsMaxSizeMap);
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de obtenerDatosDesistidos", 1);
	//
	// Ab18aUtils.obtenerDatosDesistidos(datosExcel, hojaDesistidos,
	// estiloTitulosGenerales, estiloTitulosLicitacion,
	// estiloTitulosAccesoPublico, estiloCelda, estiloFila,
	// columnsMaxSizeMap);
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de obtenerDatosEjecucion", 1);
	// }
	// Ab18aUtils.obtenerDatosEjecucion(datosExcel, hojaEjecucion,
	// estiloTitulosGenerales, estiloTitulosLicitacion,
	// estiloTitulosAccesoPublico, estiloTitulosSujeto, estiloCelda,
	// estiloFila, columnsMaxSizeMap);
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "FIN generarExcelListadoInformes", 1);
	//
	//
	// //libro
	// return libro;
	// }
	//
	// /**
	// * Generar excel listado informes oce.
	// *
	// * @param fileTitle the file title
	// * @param datosExcel the datos excel
	// * @param idioma the idioma
	// * @return the hSSF workbook
	// */
	// public static HSSFWorkbook generarExcelListadoInformesOCE(String
	// fileTitle,
	// HashMap<Object, Object> datosExcel,
	// String idioma) {
	//
	// HSSFWorkbook libro = new HSSFWorkbook();
	// HSSFSheet hoja = null;
	// try {
	//
	// Y46jRecursosManager messageSource = new Y46jRecursosManager();
	// if(idioma.equalsIgnoreCase(Y46jConstantes.IDIOMA_ES)){
	// hoja = libro.createSheet(messageSource.getMessage(
	// "registro.contratosNC.pdf.informe"));
	// }else{
	// hoja = libro.createSheet(messageSource.getMessage(
	// "registro.contratosNC.pdf.informe_eu"));
	//
	// }
	//
	// // Establecer los margenes de pagina
	// HSSFPrintSetup ps = hoja.getPrintSetup();
	//
	// ps.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// ps.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hoja.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hoja.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hoja.setMargin(HSSFSheet.LeftMargin, Double.valueOf(Ab18aUtils.valor_50)
	// .doubleValue());
	// hoja.setMargin(HSSFSheet.RightMargin, Double
	// .valueOf(Ab18aUtils.valor_50).doubleValue());
	//
	// // Establecer la cebecera y el pie de pagina
	// HSSFHeader header = hoja.getHeader();
	// header.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footer = hoja.getFooter();
	// footer.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	//
	// // Definicion de fuentes para las celdas
	// HSSFFont fuente = libro.createFont();
	// fuente.setFontHeightInPoints((short) Y46jConstantes.NUMERO_10);
	// fuente.setFontName("Arial");
	//
	// HSSFFont fuenteTitulos = libro.createFont();
	// fuenteTitulos.setFontHeightInPoints((short) Y46jConstantes.NUMERO_11);
	// fuenteTitulos.setColor(HSSFColor.BLACK.index);
	// fuenteTitulos.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD); // make it bold
	// fuenteTitulos.setFontName("Calibri");
	//
	// HSSFFont fuenteTitulosPrincipales = libro.createFont();
	// fuenteTitulosPrincipales
	// .setFontHeightInPoints((short) Y46jConstantes.NUMERO_18);
	// fuenteTitulosPrincipales.setColor(HSSFColor.BLACK.index);
	// fuenteTitulosPrincipales.setFontName("Calibri");
	//
	// // Definicion de estilo para celdas de fila de titulos NO PRINCIPALES
	// HSSFCellStyle estiloTitulosGenerales = libro.createCellStyle();
	// estiloTitulosGenerales
	// .setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index);
	// estiloTitulosGenerales.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosGenerales.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosGenerales.setFont(fuenteTitulos);
	// estiloTitulosGenerales.setWrapText(true);
	//
	// // Definicion de estilo para celdas de fila de titulos PRINCIPALES
	// HSSFCellStyle estiloTituloGeneral = libro.createCellStyle();
	// estiloTituloGeneral
	// .setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
	// estiloTituloGeneral.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloGeneral.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloGeneral.setFont(fuenteTitulosPrincipales);
	//
	// // Definicion de estilos para celdas de filas
	// HSSFCellStyle estiloCelda = libro.createCellStyle();
	// estiloCelda.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloCelda.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloCelda.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloCelda.setWrapText(true);
	// estiloCelda.setFont(fuente);
	//
	// HSSFCellStyle estiloFila = libro.createCellStyle();
	// estiloFila.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloFila.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloFila.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// // estiloFila.setWrapText(true);
	// estiloFila.setFont(fuente);
	//
	// HSSFCellStyle estiloBordeInferior = libro.createCellStyle();
	// estiloBordeInferior.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloBordeInferior.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloBordeInferior.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	// estiloBordeInferior.setWrapText(true);
	// estiloBordeInferior.setFont(fuente);
	//
	// // Estilo de fuente BOLD
	// HSSFCellStyle estiloBold = libro.createCellStyle();
	// HSSFFont font = libro.createFont();
	// font.setFontHeightInPoints((short) Y46jConstantes.NUMERO_8);
	// font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	// estiloBold.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// font.setFontName("Verdana");
	// estiloBold.setFont(font);
	// estiloBold.setWrapText(true);
	//
	// HSSFCell cell = null;
	// int rowCount = 0;
	//
	// // Obtenemos los títulos de las columnas
	//
	// Collection<Object> colTitulos = (Collection<Object>) datosExcel
	// .get("listaTitulos");
	//
	// Map<Object, Object> listaTitulosMap = new HashMap<Object, Object>();
	//
	// Iterator<Object> it = colTitulos.iterator();
	// while (it.hasNext()) {
	// listaTitulosMap = (Map<Object, Object>) it.next();
	// }
	//
	// List<Object> listaTitulos = new ArrayList<Object>();
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // listaTitulosMap
	// Iterator<?> it2 = listaTitulosMap.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaTitulos"
	// while (it2.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it2.next();
	// String valor = (String) mapa.getValue();
	// listaTitulos.add(valor);
	// }
	//
	// // Obtenemos los datos de las columnas de la hoja Formalizados
	//
	// Collection<Object> colDatos = (Collection<Object>) datosExcel
	// .get("listaHashMap");
	//
	// Map<Object, Object> listaHashMap = new HashMap<Object, Object>();
	// List<Object> listaDatos = new ArrayList<Object>();
	// List<Object> listaDatosC = new ArrayList<Object>();
	//
	// Iterator<Object> ite2 = colDatos.iterator();
	// while (ite2.hasNext()) {
	// listaHashMap = (Map<Object, Object>) ite2.next();
	// listaDatosC.add(listaHashMap);
	// }
	//
	// // Comenzamos con los datos de las filas
	// String current = null;
	// int offset = 0;
	// Map<Object, Object> columnsMaxSizeMap = new HashMap<Object, Object>();
	//
	// HSSFRow row = hoja.createRow(rowCount);
	// // Dependiendo de la posición que ocupen los titulos les pongo un color
	// // u otro..
	// for (int i = 0; i < listaTitulos.size(); i++) {
	// cell = row.createCell((short) i);
	// cell.setCellValue((String) listaTitulos.get(i));
	// cell.setCellStyle(estiloTitulosGenerales);
	//
	// // Ajustar el tamaño de la columna a su contenido
	// hoja.setColumnWidth((short) (i), Ab18aUtils.getBestColSizeEnvios(
	// listaTitulos, columnsMaxSizeMap, i,
	// (String) listaTitulos.get(i)));
	//
	// }
	//
	// rowCount++;
	//
	// for (int m = 0; m < listaDatosC.size(); m++) {
	// Map<Object, Object> contrato = (Map<Object, Object>) listaDatosC
	// .get(m);
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // contrato
	// Iterator<?> it3 = contrato.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaDatos"
	// while (it3.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it3.next();
	// String valor = (String) mapa.getValue();
	// listaDatos.add(valor);
	// }
	//
	// for (int i = 0; i < listaDatos.size(); i++) {
	//
	// row = hoja.createRow(rowCount);
	// current = (String) listaDatos.get(i);
	// offset = 0;
	//
	// if (current != null) {
	//
	// String cellValue = "";
	// for (int j = 0; j < listaTitulos.size(); j++) {
	// cell = row.createCell((short) j);
	// cellValue = (String) listaDatos.get(j);
	// cell.setCellValue(cellValue);
	//
	// cell.setCellStyle(estiloCelda);
	//
	// if (offset > 0) {
	// hoja.addMergedRegion(new Region(rowCount,
	// (short) j, rowCount + offset - 1, (short) j));
	//
	// HSSFRow r = hoja.getRow(rowCount + offset - 1);
	// r.createCell((short) j).setCellStyle(estiloFila);
	// } else {
	// cell.setCellStyle(estiloFila);
	// }
	// // Ajustar el tamaño de la columna a su contenido
	// hoja.setColumnWidth((short) (j), Ab18aUtils
	// .getBestColSizeEnvios(listaTitulos,
	// columnsMaxSizeMap, j, cellValue));
	// }
	//
	// listaDatos = (List<Object>) Ab18aUtils
	// .getObject(ArrayList.class.getName());
	// }
	//
	// if (offset > 0) {
	// rowCount += offset;
	// } else {
	// rowCount++;
	// }
	// }
	//
	// }
	//
	// } catch (Exception e) {
	// Y46jLog.error("Y46jUtils", "generarExcelListadoInformesOCE",
	// "Se ha producido un error en generar el excel del listado de informes para OCE",
	// 1);
	// }
	// return libro;
	//
	// }
	//
	// /**
	// * Generar excel listado informes oce.
	// *
	// * @param fileTitle the file title
	// * @param datosExcel the datos excel
	// * @param idioma the idioma
	// * @return the hSSF workbook
	// */
	// public static HSSFWorkbook generarExcelIndicadorGenerico(String
	// fileTitle,
	// HashMap<Object, Object> datosExcel,
	// String idioma, int tipoIndicador) {
	//
	// Y46jLog.debug("Y46jUtils", "generarExcelIndicadorGenerico",
	// "INICIO generarExcelIndicadorGenerico", 1);
	//
	// HSSFWorkbook libro = new HSSFWorkbook();
	// HSSFSheet hoja = null;
	// try {
	//
	// Y46jRecursosManager messageSource = new Y46jRecursosManager();
	// if(idioma.equalsIgnoreCase(Y46jConstantes.IDIOMA_ES)){
	// hoja = libro.createSheet(messageSource.getMessage(
	// "registro.contratosNC.pdf.informe"));
	// }else{
	// hoja = libro.createSheet(messageSource.getMessage(
	// "registro.contratosNC.pdf.informe_eu"));
	//
	// }
	//
	// String valorCeldaTotalEs =
	// messageSource.getMessage("y46jLiterales.indicador53.total");
	// String valorCeldaTotalEu =
	// messageSource.getMessage("y46jLiterales.indicador53.total_eu");
	//
	// // Establecer los margenes de pagina
	// HSSFPrintSetup ps = hoja.getPrintSetup();
	//
	// ps.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// ps.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hoja.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hoja.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hoja.setMargin(HSSFSheet.LeftMargin, Double.valueOf(Ab18aUtils.valor_50)
	// .doubleValue());
	// hoja.setMargin(HSSFSheet.RightMargin, Double
	// .valueOf(Ab18aUtils.valor_50).doubleValue());
	//
	// // Establecer la cebecera y el pie de pagina
	// HSSFHeader header = hoja.getHeader();
	// header.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footer = hoja.getFooter();
	// footer.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	//
	// // Definicion de fuentes para las celdas
	// HSSFFont fuente = libro.createFont();
	// fuente.setFontHeightInPoints((short) Y46jConstantes.NUMERO_10);
	// fuente.setFontName("Arial");
	//
	// HSSFFont fuenteTitulos = libro.createFont();
	// fuenteTitulos.setFontHeightInPoints((short) Y46jConstantes.NUMERO_11);
	// fuenteTitulos.setColor(HSSFColor.BLACK.index);
	// fuenteTitulos.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD); // make it bold
	// fuenteTitulos.setFontName("Calibri");
	//
	// HSSFFont fuenteTitulosPrincipales = libro.createFont();
	// fuenteTitulosPrincipales
	// .setFontHeightInPoints((short) Y46jConstantes.NUMERO_18);
	// fuenteTitulosPrincipales.setColor(HSSFColor.BLACK.index);
	// fuenteTitulosPrincipales.setFontName("Calibri");
	//
	// // Definicion de estilo para celdas de fila de titulos NO PRINCIPALES
	// HSSFCellStyle estiloTitulosGenerales = libro.createCellStyle();
	// estiloTitulosGenerales
	// .setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index);
	// estiloTitulosGenerales.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosGenerales.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosGenerales.setFont(fuenteTitulos);
	// estiloTitulosGenerales.setWrapText(true);
	//
	// // Definicion de estilo para celdas de fila de titulos PRINCIPALES
	// HSSFCellStyle estiloTituloGeneral = libro.createCellStyle();
	// estiloTituloGeneral
	// .setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
	// estiloTituloGeneral.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloGeneral.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloGeneral.setFont(fuenteTitulosPrincipales);
	//
	// // Definicion de estilos para celdas de filas
	// HSSFCellStyle estiloCelda = libro.createCellStyle();
	// estiloCelda.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloCelda.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloCelda.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloCelda.setWrapText(true);
	// estiloCelda.setFont(fuente);
	//
	// // Definicion de estilos para celdas de filas
	// HSSFCellStyle estiloCeldaTotal = libro.createCellStyle();
	// estiloCeldaTotal
	// .setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
	// estiloCeldaTotal.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloCeldaTotal.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloCelda.setWrapText(true);
	// estiloCelda.setFont(fuente);
	//
	// HSSFCellStyle estiloFila = libro.createCellStyle();
	// estiloFila.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloFila.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloFila.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// // estiloFila.setWrapText(true);
	// estiloFila.setFont(fuente);
	//
	// HSSFCellStyle estiloBordeInferior = libro.createCellStyle();
	// estiloBordeInferior.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloBordeInferior.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloBordeInferior.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	// estiloBordeInferior.setWrapText(true);
	// estiloBordeInferior.setFont(fuente);
	//
	// // Estilo de fuente BOLD
	// HSSFCellStyle estiloBold = libro.createCellStyle();
	// HSSFFont font = libro.createFont();
	// font.setFontHeightInPoints((short) Y46jConstantes.NUMERO_8);
	// font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	// estiloBold.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// font.setFontName("Verdana");
	// estiloBold.setFont(font);
	// estiloBold.setWrapText(true);
	//
	// HSSFCell cell = null;
	// int rowCount = 0;
	//
	// Y46jLog.debug("Y46jUtils", "generarExcelIndicadorGenerico",
	// "Antes de obtener columnas titulos", 1);
	//
	// // Obtenemos los titulos de las columnas
	//
	// Collection<Object> colTitulos = (Collection<Object>) datosExcel
	// .get("listaTitulos");
	//
	// Map<Object, Object> listaTitulosMap = new HashMap<Object, Object>();
	//
	// Iterator<Object> it = colTitulos.iterator();
	// while (it.hasNext()) {
	// listaTitulosMap = (Map<Object, Object>) it.next();
	// }
	//
	// List<Object> listaTitulos = new ArrayList<Object>();
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // listaTitulosMap
	// Iterator<?> it2 = listaTitulosMap.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaTitulos"
	// while (it2.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it2.next();
	// String valor = (String) mapa.getValue();
	// listaTitulos.add(valor);
	// }
	//
	// Y46jLog.debug("Y46jUtils", "generarExcelIndicadorGenerico",
	// "Antes de obtener datos", 1);
	//
	// // Obtenemos los datos de las columnas de la hoja
	//
	// Collection<Object> colDatos = (Collection<Object>) datosExcel
	// .get("listaHashMap");
	//
	// Map<Object, Object> listaHashMap = new HashMap<Object, Object>();
	// List<Object> listaDatos = new ArrayList<Object>();
	// List<Object> listaDatosC = new ArrayList<Object>();
	//
	// Iterator<Object> ite2 = colDatos.iterator();
	// while (ite2.hasNext()) {
	// listaHashMap = (Map<Object, Object>) ite2.next();
	// listaDatosC.add(listaHashMap);
	// }
	//
	// Y46jLog.debug("Y46jUtils", "generarExcelIndicadorGenerico",
	// "Despues de obtener datos", 1);
	//
	// // Comenzamos con los datos de las filas
	// String current = null;
	// int offset = 0;
	// Map<Object, Object> columnsMaxSizeMap = new HashMap<Object, Object>();
	//
	// HSSFRow row = hoja.createRow(rowCount);
	// // Dependiendo de la posición que ocupen los titulos les pongo un color
	// // u otro..
	// for (int i = 0; i < listaTitulos.size(); i++) {
	// cell = row.createCell((short) i);
	// cell.setCellValue((String) listaTitulos.get(i));
	// cell.setCellStyle(estiloTitulosGenerales);
	//
	// // Ajustar el tamaño de la columna a su contenido
	// hoja.setColumnWidth((short) (i), Ab18aUtils.getBestColSizeEnvios(
	// listaTitulos, columnsMaxSizeMap, i,
	// (String) listaTitulos.get(i)));
	//
	// }
	//
	// rowCount++;
	//
	// Y46jLog.debug("Y46jUtils", "generarExcelIndicadorGenerico",
	// "Antes de componer excel", 1);
	//
	// for (int m = 0; m < listaDatosC.size(); m++) {
	// Map<Object, Object> contrato = (Map<Object, Object>) listaDatosC
	// .get(m);
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // contrato
	// Iterator<?> it3 = contrato.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaDatos"
	// while (it3.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it3.next();
	// String valor = (String) mapa.getValue();
	// listaDatos.add(valor);
	// }
	//
	// for (int i = 0; i < listaDatos.size(); i++) {
	//
	// row = hoja.createRow(rowCount);
	// current = (String) listaDatos.get(i);
	// offset = 0;
	//
	// if (current != null) {
	//
	// String cellValue = "";
	// for (int j = 0; j < listaTitulos.size(); j++) {
	// cell = row.createCell((short) j);
	// cellValue = (String) listaDatos.get(j);
	// cell.setCellValue(cellValue);
	//
	// if (Ab18aUtils.notNullAndNotEmpty(cellValue)
	// && (valorCeldaTotalEs.equalsIgnoreCase(cellValue)
	// || valorCeldaTotalEu.equalsIgnoreCase(cellValue))){
	// cell.setCellStyle(estiloCeldaTotal);
	// }else{
	// cell.setCellStyle(estiloCelda);
	// }
	//
	// if (offset > 0) {
	// hoja.addMergedRegion(new Region(rowCount,
	// (short) j, rowCount + offset - 1, (short) j));
	//
	// HSSFRow r = hoja.getRow(rowCount + offset - 1);
	//
	// if (Ab18aUtils.notNullAndNotEmpty(cellValue)
	// && (valorCeldaTotalEs.equalsIgnoreCase(cellValue)
	// || valorCeldaTotalEu.equalsIgnoreCase(cellValue))){
	// r.createCell((short) j).setCellStyle(estiloCeldaTotal);
	// }else{
	// r.createCell((short) j).setCellStyle(estiloFila);
	// }
	// } else {
	//
	// if (Ab18aUtils.notNullAndNotEmpty(cellValue)
	// && (valorCeldaTotalEs.equalsIgnoreCase(cellValue)
	// || valorCeldaTotalEu.equalsIgnoreCase(cellValue))){
	// cell.setCellStyle(estiloCeldaTotal);
	// }else{
	// cell.setCellStyle(estiloFila);
	// }
	// }
	// // Ajustar el tamaño de la columna a su contenido
	// hoja.setColumnWidth((short) (j), Ab18aUtils
	// .getBestColSizeEnvios(listaTitulos,
	// columnsMaxSizeMap, j, cellValue));
	// }
	//
	// listaDatos = (List<Object>) Ab18aUtils
	// .getObject(ArrayList.class.getName());
	// }
	//
	// if (offset > 0) {
	// rowCount += offset;
	// } else {
	// rowCount++;
	// }
	// }
	// }
	//
	// Y46jLog.debug("Y46jUtils", "generarExcelIndicadorGenerico",
	// "Despues de componer excel", 1);
	//
	// } catch (Exception e) {
	// Y46jLog.error("Y46jUtils",
	// "generarExcelIndicadorGenerico",
	// "Se ha producido un error en generar el excel del listado de informes de indicadores: "
	// + e.getMessage(), 1);
	// }
	// return libro;
	//
	// }
	//
	// public static HSSFWorkbook generarExcelIndicador59(String fileTitle,
	// HashMap<Object, Object> datosExcel, String idioma) {
	//
	// Y46jLog.debug("Y46jUtils", "generarExcelIndicador59",
	// "INICIO generarExcelIndicador59", 1);
	//
	// HSSFWorkbook libro = new HSSFWorkbook();
	// HSSFSheet hojaAgrupados = null;
	// HSSFSheet hojaDetalle = null;
	// try {
	//
	// Y46jRecursosManager messageSource = new Y46jRecursosManager();
	//
	// if(idioma.equalsIgnoreCase(Y46jConstantes.IDIOMA_ES)){
	// hojaAgrupados = libro.createSheet(messageSource.getMessage(
	// "y46jLiterales.indicador59.agrupadoPorEmpresa"));
	// hojaDetalle = libro.createSheet(messageSource.getMessage(
	// "y46jLiterales.indicador59.detallePorEmpresa"));
	// }else{
	// hojaAgrupados = libro.createSheet(messageSource.getMessage(
	// "y46jLiterales.indicador59.agrupadoPorEmpresa_eu"));
	// hojaDetalle = libro.createSheet(messageSource.getMessage(
	// "y46jLiterales.indicador59.detallePorEmpresa_eu"));
	// }
	//
	// // Establecer los margenes de pagina
	// HSSFPrintSetup psAgrupado = hojaAgrupados.getPrintSetup();
	// HSSFPrintSetup psDetalle = hojaDetalle.getPrintSetup();
	//
	// psAgrupado.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// psAgrupado.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hojaAgrupados.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hojaAgrupados.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaAgrupados.setMargin(HSSFSheet.LeftMargin,
	// Double.valueOf(Ab18aUtils.valor_50)
	// .doubleValue());
	// hojaAgrupados.setMargin(HSSFSheet.RightMargin, Double
	// .valueOf(Ab18aUtils.valor_50).doubleValue());
	//
	// psDetalle.setHeaderMargin(Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// psDetalle.setFooterMargin(Double.valueOf(Ab18aUtils.valor_35).doubleValue());
	// hojaDetalle.setMargin(HSSFSheet.TopMargin, (double) 1);
	// hojaDetalle.setMargin(HSSFSheet.BottomMargin,
	// Double.valueOf(Ab18aUtils.valor_50).doubleValue());
	// hojaDetalle.setMargin(HSSFSheet.LeftMargin,
	// Double.valueOf(Ab18aUtils.valor_50)
	// .doubleValue());
	// hojaDetalle.setMargin(HSSFSheet.RightMargin, Double
	// .valueOf(Ab18aUtils.valor_50).doubleValue());
	//
	// // Establecer la cebecera y el pie de pagina
	// HSSFHeader headerAgrupados = hojaAgrupados.getHeader();
	// headerAgrupados.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footerAgrupados = hojaAgrupados.getFooter();
	// footerAgrupados.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	//
	// HSSFHeader headerDetalle = hojaDetalle.getHeader();
	// headerDetalle.setCenter(HSSFHeader.font("Verdana-Bold", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + fileTitle);
	// HSSFFooter footerDetalle = hojaDetalle.getFooter();
	// footerDetalle.setRight(HSSFHeader.font("Verdana", "Bold")
	// + HSSFHeader.fontSize((short) Y46jConstantes.NUMERO_8)
	// + HSSFFooter.page() + " / " + HSSFFooter.numPages());
	//
	// // Definicion de fuentes para las celdas
	// HSSFFont fuente = libro.createFont();
	// fuente.setFontHeightInPoints((short) Y46jConstantes.NUMERO_10);
	// fuente.setFontName("Arial");
	//
	// HSSFFont fuenteTitulos = libro.createFont();
	// fuenteTitulos.setFontHeightInPoints((short) Y46jConstantes.NUMERO_11);
	// fuenteTitulos.setColor(HSSFColor.BLACK.index);
	// fuenteTitulos.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD); // make it bold
	// fuenteTitulos.setFontName("Calibri");
	//
	// HSSFFont fuenteTitulosPrincipales = libro.createFont();
	// fuenteTitulosPrincipales
	// .setFontHeightInPoints((short) Y46jConstantes.NUMERO_18);
	// fuenteTitulosPrincipales.setColor(HSSFColor.BLACK.index);
	// fuenteTitulosPrincipales.setFontName("Calibri");
	//
	// // Definicion de estilo para celdas de fila de titulos NO PRINCIPALES
	// HSSFCellStyle estiloTitulosGenerales = libro.createCellStyle();
	// estiloTitulosGenerales
	// .setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index);
	// estiloTitulosGenerales.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTitulosGenerales.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTitulosGenerales.setFont(fuenteTitulos);
	// estiloTitulosGenerales.setWrapText(true);
	//
	// // Definicion de estilo para celdas de fila de titulos PRINCIPALES
	// HSSFCellStyle estiloTituloGeneral = libro.createCellStyle();
	// estiloTituloGeneral
	// .setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
	// estiloTituloGeneral.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// estiloTituloGeneral.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloTituloGeneral.setFont(fuenteTitulosPrincipales);
	//
	// // Definicion de estilos para celdas de filas
	// HSSFCellStyle estiloCelda = libro.createCellStyle();
	// estiloCelda.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloCelda.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloCelda.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloCelda.setWrapText(true);
	// estiloCelda.setFont(fuente);
	//
	// HSSFCellStyle estiloFila = libro.createCellStyle();
	// estiloFila.setFillBackgroundColor(HSSFColor.WHITE.index);
	// estiloFila.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	// estiloFila.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// // estiloFila.setWrapText(true);
	// estiloFila.setFont(fuente);
	//
	// HSSFCellStyle estiloBordeInferior = libro.createCellStyle();
	// estiloBordeInferior.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// estiloBordeInferior.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// estiloBordeInferior.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	// estiloBordeInferior.setWrapText(true);
	// estiloBordeInferior.setFont(fuente);
	//
	// // Estilo de fuente BOLD
	// HSSFCellStyle estiloBold = libro.createCellStyle();
	// HSSFFont font = libro.createFont();
	// font.setFontHeightInPoints((short) Y46jConstantes.NUMERO_8);
	// font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	// estiloBold.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	// font.setFontName("Verdana");
	// estiloBold.setFont(font);
	// estiloBold.setWrapText(true);
	//
	// String nombreTitulosAgrupados = "listaTitulosAgrupado";
	// String nombreDatosAgrupados = "listaHashMapAgrupado";
	// obtenerDatosIndicador59(
	// datosExcel, hojaAgrupados, nombreTitulosAgrupados, nombreDatosAgrupados,
	// estiloTitulosGenerales, estiloCelda, estiloFila);
	//
	// String nombreTitulosDetalle = "listaTitulosDetalle";
	// String nombreDatosdetalle = "listaHashMapDetalle";
	// obtenerDatosIndicador59(
	// datosExcel, hojaDetalle, nombreTitulosDetalle, nombreDatosdetalle,
	// estiloTitulosGenerales, estiloCelda, estiloFila);
	//
	// } catch (Exception e) {
	// Y46jLog.error("Y46jUtils",
	// "generarExcelIndicador59",
	// "Se ha producido un error en generar el excel del listado de informes 53:"
	// + e.getMessage(), 1);
	// }
	//
	// Y46jLog.debug("Y46jUtils", "generarExcelIndicador59",
	// "FIN generarExcelIndicador59", 1);
	//
	// return libro;
	// }
	//
	// private static void obtenerDatosIndicador59(HashMap<Object, Object>
	// datosExcel, HSSFSheet hoja,
	// String nombreTitulos,String nombreDatos,
	// HSSFCellStyle estiloTitulosGenerales,
	// HSSFCellStyle estiloCelda,
	// HSSFCellStyle estiloFila){
	//
	// HSSFCell cell = null;
	// int rowCount = 0;
	//
	// // Obtenemos los titulos de las columnas
	// Collection<Object> colTitulos = (Collection<Object>) datosExcel
	// .get(nombreTitulos);
	//
	// Map<Object, Object> listaTitulosMap = new HashMap<Object, Object>();
	//
	// Iterator<Object> it = colTitulos.iterator();
	// while (it.hasNext()) {
	// listaTitulosMap = (Map<Object, Object>) it.next();
	// }
	//
	// List<Object> listaTitulos = new ArrayList<Object>();
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // listaTitulosMap
	// Iterator<?> it2 = listaTitulosMap.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaTitulos"
	// while (it2.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it2.next();
	// String valor = (String) mapa.getValue();
	// listaTitulos.add(valor);
	// }
	//
	// // Obtenemos los datos de las columnas de la hoja Formalizados
	//
	// Collection<Object> colDatos = (Collection<Object>) datosExcel
	// .get(nombreDatos);
	//
	// Map<Object, Object> listaHashMap = new HashMap<Object, Object>();
	// List<Object> listaDatos = new ArrayList<Object>();
	// List<Object> listaDatosC = new ArrayList<Object>();
	//
	// Iterator<Object> ite2 = colDatos.iterator();
	// while (ite2.hasNext()) {
	// listaHashMap = (Map<Object, Object>) ite2.next();
	// listaDatosC.add(listaHashMap);
	// }
	//
	// // Comenzamos con los datos de las filas
	// String current = null;
	// int offset = 0;
	// Map<Object, Object> columnsMaxSizeMap = new HashMap<Object, Object>();
	//
	// HSSFRow row = hoja.createRow(rowCount);
	// // Dependiendo de la posicion que ocupen los titulos les pongo un color
	// // u otro..
	// for (int i = 0; i < listaTitulos.size(); i++) {
	// cell = row.createCell((short) i);
	// cell.setCellValue((String) listaTitulos.get(i));
	// cell.setCellStyle(estiloTitulosGenerales);
	//
	// // Ajustar el tamaño de la columna a su contenido
	// hoja.setColumnWidth((short) (i), Ab18aUtils.getBestColSizeEnvios(
	// listaTitulos, columnsMaxSizeMap, i,
	// (String) listaTitulos.get(i)));
	//
	// }
	//
	// rowCount++;
	//
	// for (int m = 0; m < listaDatosC.size(); m++) {
	// Map<Object, Object> contrato = (Map<Object, Object>) listaDatosC
	// .get(m);
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // contrato
	// Iterator<?> it3 = contrato.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaDatos"
	// while (it3.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it3.next();
	// String valor = (String) mapa.getValue();
	// listaDatos.add(valor);
	// }
	//
	// for (int i = 0; i < listaDatos.size(); i++) {
	//
	// row = hoja.createRow(rowCount);
	// current = (String) listaDatos.get(i);
	// offset = 0;
	//
	// if (current != null) {
	//
	// String cellValue = "";
	// for (int j = 0; j < listaTitulos.size(); j++) {
	// cell = row.createCell((short) j);
	// cellValue = (String) listaDatos.get(j);
	// cell.setCellValue(cellValue);
	//
	// cell.setCellStyle(estiloCelda);
	//
	// if (offset > 0) {
	// hoja.addMergedRegion(new Region(rowCount,
	// (short) j, rowCount + offset - 1, (short) j));
	//
	// HSSFRow r = hoja.getRow(rowCount + offset - 1);
	// r.createCell((short) j).setCellStyle(estiloFila);
	// } else {
	// cell.setCellStyle(estiloFila);
	// }
	// // Ajustar el tamano de la columna a su contenido
	// hoja.setColumnWidth((short) (j), Ab18aUtils
	// .getBestColSizeEnvios(listaTitulos,
	// columnsMaxSizeMap, j, cellValue));
	// }
	//
	// listaDatos = (List<Object>) Ab18aUtils
	// .getObject(ArrayList.class.getName());
	// }
	//
	// if (offset > 0) {
	// rowCount += offset;
	// } else {
	// rowCount++;
	// }
	// }
	// }
	// }
	//
	// /**
	// * Gets the best col size envios.
	// *
	// * @param titleList
	// * the title list
	// * @param columnsMaxSizeMap
	// * the columns max size map
	// * @param cellIndex
	// * the cell index
	// * @param cellValue
	// * the cell value
	// * @return the best col size envios
	// */
	// private static short getBestColSizeEnvios(List<Object> titleList,
	// Map<Object, Object> columnsMaxSizeMap, int cellIndex,
	// String cellValue) {
	//
	// if (cellValue == null) {
	// cellValue = "";
	// }
	//
	// // Ajustar el tamaño de la columna a su contenido
	// if (columnsMaxSizeMap.get(Ab18aUtils.crearInteger(cellIndex)) == null
	// || ((Integer) columnsMaxSizeMap.get(Ab18aUtils
	// .crearInteger(cellIndex))).intValue() < cellValue
	// .length()) {
	// int titleSize = ((String) (titleList.get(cellIndex))).length();
	// int dataSize = cellValue.length();
	// if (titleSize >= dataSize) {
	// columnsMaxSizeMap.put(Ab18aUtils.crearInteger(cellIndex),
	// Ab18aUtils.crearInteger(titleSize));
	// } else {
	// columnsMaxSizeMap.put(Ab18aUtils.crearInteger(cellIndex),
	// Ab18aUtils.crearInteger(dataSize));
	//
	// }
	// // Ajustar la col para que entren como max 60 caracteres y 10 como
	// // minimo.
	// int size = ((Integer) columnsMaxSizeMap.get(Ab18aUtils
	// .crearInteger(cellIndex))).intValue();
	// if (size > Y46jConstantes.NUMERO_60) {
	// columnsMaxSizeMap.put(Ab18aUtils.crearInteger(cellIndex),
	// Ab18aUtils.crearInteger(Y46jConstantes.NUMERO_60));
	// } else if (size < Y46jConstantes.NUMERO_10) {
	// columnsMaxSizeMap.put(Ab18aUtils.crearInteger(cellIndex),
	// Ab18aUtils.crearInteger(Y46jConstantes.NUMERO_10));
	// }
	// }
	// return (short) ((((Y46jConstantes.NUMERO_40 * Y46jConstantes.NUMERO_8) /
	// ((double) 1 / Y46jConstantes.NUMERO_20)) / Y46jConstantes.NUMERO_20) *
	// ((Integer) columnsMaxSizeMap
	// .get(Ab18aUtils.crearInteger(cellIndex))).intValue());
	// }
	//
	//
	//
	// /**
	// * Convertir objetos.
	// *
	// * @param xml
	// * the xml
	// * @return the y4602 s00
	// */
	// public static Y4602S00 convertirObjetos(String xml) {
	//
	// Y4602S00 contratos = new Y4602S00();
	// Y4603S00 datosMEH = new Y4603S00();
	// Y46jConvertirJaxb jaxb = new Y46jConvertirJaxb();
	// TipoFichaContrato tipoFichaContrato = jaxb.xmlToContrato(xml);
	//
	// contratos.setCodContrato(tipoFichaContrato.getCodContrato());
	// datosMEH.setCodContrato(tipoFichaContrato.getCodContrato());
	// if (tipoFichaContrato.getMateriaContrato() != null
	// && Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getMateriaContrato().getCodMateriaCpv())) {
	// contratos.setCodMateria(Integer.valueOf(tipoFichaContrato
	// .getMateriaContrato().getCodMateriaCpv()));
	// contratos.setDesMateriaEs(tipoFichaContrato.getMateriaContrato()
	// .getDescripcionEs());
	// contratos.setDesMateriaEu(tipoFichaContrato.getMateriaContrato()
	// .getDescripcionEu());
	//
	// }
	// contratos.setTituloEs(tipoFichaContrato.getTituloContratoEs());
	// contratos.setTituloEu(tipoFichaContrato.getTituloContratoEu());
	// if (tipoFichaContrato.getPoderAdjudicador() != null) {
	// contratos.setCodPoderAdj(tipoFichaContrato.getPoderAdjudicador()
	// .getCodPoderAdj());
	// contratos.setDesPoderAdjEs(tipoFichaContrato.getPoderAdjudicador()
	// .getDescripcionEs());
	// contratos.setDesPoderAdjEu(tipoFichaContrato.getPoderAdjudicador()
	// .getDescripcionEu());
	// datosMEH.setCodPoder(tipoFichaContrato.getPoderAdjudicador()
	// .getCodPoderMeh());
	// contratos.setNifPoderAdj(tipoFichaContrato.getPoderAdjudicador()
	// .getNIFPoderAdj());
	// }
	// if (tipoFichaContrato.getOrganoContratante() != null) {
	// contratos.setCodOrgano(tipoFichaContrato.getOrganoContratante()
	// .getCodOrgContratante());
	// contratos.setDesOrganoEs(tipoFichaContrato.getOrganoContratante()
	// .getDescripcionEs());
	// contratos.setDesOrganoEu(tipoFichaContrato.getOrganoContratante()
	// .getDescripcionEu());
	// datosMEH.setCodOrgano(tipoFichaContrato.getOrganoContratante()
	// .getCodOrganoMeh());
	// contratos.setNifOrgano(tipoFichaContrato.getOrganoContratante()
	// .getNIFOrgContratante());
	// }
	// if (tipoFichaContrato.getTipoContrato() != null) {
	// contratos.setIdTipoContrato(tipoFichaContrato.getTipoContrato()
	// .getIdTipoContrato());
	// contratos.setDesTipoEs(tipoFichaContrato.getTipoContrato()
	// .getDescripcionEs());
	// contratos.setDesTipoEu(tipoFichaContrato.getTipoContrato()
	// .getDescripcionEu());
	// datosMEH.setCodTipo(tipoFichaContrato.getTipoContrato()
	// .getCodTipoContratoMeh());
	// }
	// contratos.setObjetoEs(tipoFichaContrato.getObjetoContratoEs());
	// contratos.setObjetoEu(tipoFichaContrato.getObjetoContratoEu());
	// if (tipoFichaContrato.getFechaPublicacionDOUE() != null) {
	// contratos.setFecDOUE(tipoFichaContrato.getFechaPublicacionDOUE());
	// contratos.setFecDOUEString(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_DIA_MES_ANO,
	// tipoFichaContrato.getFechaPublicacionDOUE()));
	// contratos.setFecDOUEStringEu(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_ANO_MES_DIA,
	// tipoFichaContrato.getFechaPublicacionDOUE()));
	// contratos.setFecDOUEPerfil(true);
	// }
	// if (tipoFichaContrato.getFechaPublicacionBOE() != null) {
	// contratos.setFecBOE(tipoFichaContrato.getFechaPublicacionBOE());
	// contratos.setFecBOEString(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_DIA_MES_ANO,
	// tipoFichaContrato.getFechaPublicacionBOE()));
	// contratos.setFecBOEStringEu(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_ANO_MES_DIA,
	// tipoFichaContrato.getFechaPublicacionBOE()));
	// contratos.setFechaBOEPerfil(true);
	// }
	//
	// if (tipoFichaContrato.getFechaPublicacionBOPV() != null) {
	// contratos.setFecBOPV(tipoFichaContrato.getFechaPublicacionBOPV());
	// contratos.setFecBOPVString(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_DIA_MES_ANO,
	// tipoFichaContrato.getFechaPublicacionBOPV()));
	// contratos.setFecBOPVStringEu(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_ANO_MES_DIA,
	// tipoFichaContrato.getFechaPublicacionBOPV()));
	// contratos.setFecBOPVPerfil(true);
	// }
	//
	// if (tipoFichaContrato.getFechaFormalizacion() != null) {
	// contratos.setFecForm(tipoFichaContrato.getFechaFormalizacion());
	// contratos.setFecFormString(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_DIA_MES_ANO,
	// tipoFichaContrato.getFechaFormalizacion()));
	// contratos.setFecFormStringEu(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_ANO_MES_DIA,
	// tipoFichaContrato.getFechaFormalizacion()));
	// }
	// if (tipoFichaContrato.getFechaAdjudicacion() != null) {
	// contratos.setFecAdj(tipoFichaContrato.getFechaAdjudicacion());
	// contratos.setFecAdjString(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_DIA_MES_ANO,
	// tipoFichaContrato.getFechaAdjudicacion()));
	// contratos.setFecAdjStringEu(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_ANO_MES_DIA,
	// tipoFichaContrato.getFechaAdjudicacion()));
	// }
	// if (tipoFichaContrato.getAcuerdoMarco() != null
	// && tipoFichaContrato.getAcuerdoMarco().value()
	// .equals(Y46jConstantes.CTE_TRUE)) {
	// contratos.setConMarco(true);
	// contratos.setConMarcoString(Y46jConstantes.CTE_SI);
	// contratos.setMarcoPerfil(true);
	// } else if (tipoFichaContrato.getAcuerdoMarco() != null
	// && tipoFichaContrato.getAcuerdoMarco().value()
	// .equals(Y46jConstantes.CTE_FALSE)) {
	// contratos.setConMarco(false);
	// contratos.setConMarcoString(Y46jConstantes.CTE_NO);
	// contratos.setMarcoPerfil(true);
	// } else {
	// contratos.setConMarco(null);
	// }
	// contratos.setAnio(tipoFichaContrato.getAnioContrato());
	// if (tipoFichaContrato.getTipoAdministracion() != null) {
	// contratos.setCodTipoAdm(tipoFichaContrato.getTipoAdministracion()
	// .getCodTipoAdminMeh());
	// contratos.setDesTipoAdmEs(tipoFichaContrato.getTipoAdministracion()
	// .getDescTipoAdminEs());
	// contratos.setDesTipoAdmEu(tipoFichaContrato.getTipoAdministracion()
	// .getDescTipoAdminEu());
	// datosMEH.setCodTipoAdmin(String.valueOf(tipoFichaContrato
	// .getTipoAdministracion().getCodTipoAdminMeh()));
	// }
	// if (tipoFichaContrato.getTipoAdministracionLocal() != null) {
	// contratos.setCodTipoAdmLocal(tipoFichaContrato
	// .getTipoAdministracionLocal().getCodTipoAdminLocalMeh());
	// contratos.setDesTipoAdmLocEs(tipoFichaContrato
	// .getTipoAdministracionLocal().getDescTipoAdminEs());
	// contratos.setDesTipoAdmLocEu(tipoFichaContrato
	// .getTipoAdministracionLocal().getDescTipoAdminEu());
	// datosMEH.setCodTipoAdmnLoc(String.valueOf(tipoFichaContrato
	// .getTipoAdministracionLocal().getCodTipoAdminLocalMeh()));
	// }
	// if (tipoFichaContrato.getEntidadImpulsora() != null) {
	// contratos.setCodEntImp(tipoFichaContrato.getEntidadImpulsora()
	// .getCodEntImp());
	// contratos.setDesEntImpEs(tipoFichaContrato.getEntidadImpulsora()
	// .getDescripcionEs());
	// contratos.setDesEntImpEu(tipoFichaContrato.getEntidadImpulsora()
	// .getDescripcionEu());
	// contratos.setNifEntImp(tipoFichaContrato.getEntidadImpulsora()
	// .getNIFEntImp());
	// datosMEH.setCodEntidad(tipoFichaContrato.getEntidadImpulsora()
	// .getCodEntidadMeh());
	// }
	// if (tipoFichaContrato.getFechaPublicacionPBTH() != null) {
	// contratos.setFecPBTH(tipoFichaContrato.getFechaPublicacionPBTH());
	// contratos.setFecPBTHString(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_DIA_MES_ANO,
	// tipoFichaContrato.getFechaPublicacionPBTH()));
	// contratos.setFecPBTHStringEu(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_ANO_MES_DIA,
	// tipoFichaContrato.getFechaPublicacionPBTH()));
	// contratos.setFecPBTHPerfil(true);
	// }
	//
	// if (tipoFichaContrato.getFechaPrimeraPublicacionPerfil() != null) {
	// contratos.setFecPerfil(tipoFichaContrato
	// .getFechaPrimeraPublicacionPerfil());
	// contratos.setFecPerfilString(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_DIA_MES_ANO,
	// tipoFichaContrato.getFechaPrimeraPublicacionPerfil()));
	// contratos.setFecPerfilStringEu(Y46jFechas.getTime(
	// Y46jConstantes.CTE_MASCARA_FECHA_ANO_MES_DIA,
	// tipoFichaContrato.getFechaPrimeraPublicacionPerfil()));
	// }
	// if (tipoFichaContrato.getTramite() != null) {
	// contratos.setCodTramite(tipoFichaContrato.getTramite()
	// .getCodTramite());
	// contratos.setDesTramiteEs(tipoFichaContrato.getTramite()
	// .getDescripcionEs());
	// contratos.setDesTramiteEu(tipoFichaContrato.getTramite()
	// .getDescripcionEu());
	// datosMEH.setCodTramite(tipoFichaContrato.getTramite()
	// .getCodTramiteMeh());
	// }
	//
	// if (tipoFichaContrato.getCriteriosAdjudicacion() != null) {
	// contratos.setCodCritAdj(tipoFichaContrato
	// .getCriteriosAdjudicacion().getCodTramite());
	// contratos.setDesCritAdjEs(tipoFichaContrato
	// .getCriteriosAdjudicacion().getDescripcionEs());
	// contratos.setDesCritAdjEu(tipoFichaContrato
	// .getCriteriosAdjudicacion().getDescripcionEu());
	// datosMEH.setCodCritAdj(tipoFichaContrato.getCriteriosAdjudicacion()
	// .getCodCriteriosAdjudicacionMeh());
	//
	// }
	//
	// if (tipoFichaContrato.getProcTramitacion() != null) {
	// contratos.setCodProcAdj(String.valueOf(tipoFichaContrato
	// .getProcTramitacion().getCodTramite()));
	// contratos.setDesProcAdjEs(tipoFichaContrato.getProcTramitacion()
	// .getDescripcionEs());
	// contratos.setDesProcAdjEu(tipoFichaContrato.getProcTramitacion()
	// .getDescripcionEu());
	// datosMEH.setCodProcAdj(tipoFichaContrato.getProcTramitacion()
	// .getCodTipoTramitacionMeh());
	// }
	//
	// contratos.setPlazo(tipoFichaContrato.getPlazoEjecucion());
	//
	// Ab18aUtils.convertirObjetos2(tipoFichaContrato, contratos);
	// contratos.setIdMeh(datosMEH);
	//
	// return contratos;
	// }
	// /**
	// * Convertir objetos2.
	// *
	// * @param tipoFichaContrato
	// * the tipo ficha contrato
	// * @param contratos
	// * the contratos
	// */
	// private static void convertirObjetos2(TipoFichaContrato
	// tipoFichaContrato,
	// Y4602S00 contratos) {
	//
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getImporteLicitacionSinIva())) {
	//
	// contratos.setImportSinIvaDouble(new BigDecimal(tipoFichaContrato
	// .getImporteLicitacionSinIva().replace(",", ".")));
	//
	// contratos.setImportSinIva(Ab18aUtils
	// .mostrarNumeroBigDecimal(tipoFichaContrato
	// .getImporteLicitacionSinIva()));
	//
	// }
	//
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getImporteAdjudicacionSinIva())) {
	//
	// contratos.setImpAdjSinIvaDouble(new BigDecimal(tipoFichaContrato
	// .getImporteAdjudicacionSinIva().replace(",", ".")));
	//
	// contratos.setImpAdjSinIva(Ab18aUtils
	// .mostrarNumeroBigDecimal(tipoFichaContrato
	// .getImporteAdjudicacionSinIva()));
	//
	// }
	//
	// if (tipoFichaContrato.getAmbito() != null) {
	// contratos.setAmbito(tipoFichaContrato.getAmbito().getIdAmbito());
	// contratos.setAmbitoDesC(tipoFichaContrato.getAmbito()
	// .getAmbitoDesc());
	// contratos.setAmbitoDesU(tipoFichaContrato.getAmbito()
	// .getAmbitoDesu());
	// }
	//
	// if (tipoFichaContrato.getContratacionLotes() != null
	// && tipoFichaContrato.getContratacionLotes().value()
	// .equals(Y46jConstantes.CTE_TRUE)) {
	// contratos.setConLotes(true);
	// contratos.setConLotesString(Y46jConstantes.CTE_SI);
	// contratos.setLotesPerfil(true);
	// } else if (tipoFichaContrato.getContratacionLotes() != null
	// && tipoFichaContrato.getContratacionLotes().value()
	// .equals(Y46jConstantes.CTE_FALSE)) {
	// contratos.setConLotes(false);
	// contratos.setConLotesString(Y46jConstantes.CTE_NO);
	// contratos.setLotesPerfil(true);
	// } else {
	// contratos.setConLotes(null);
	// }
	//
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getIVAImporteAdjudicacion())) {
	// contratos.setAdjTipoIva(tipoFichaContrato
	// .getIVAImporteAdjudicacion());
	// contratos.setAdjTipoIvaPerfil(true);
	//
	// }
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato.getUrlAnuncioEs())) {
	// contratos.setUrlAnuncioEs(tipoFichaContrato.getUrlAnuncioEs());
	//
	// }
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato.getUrlAnuncioEu())) {
	// contratos.setUrlAnuncioEu(tipoFichaContrato.getUrlAnuncioEu());
	//
	// }
	//
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getUrlLogoPoderAdjudicador())) {
	// contratos.setUrlPoder(tipoFichaContrato
	// .getUrlLogoPoderAdjudicador());
	// }
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getMesaContratacion())) {
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getMesaContratacion().getIdMesaContratacion())) {
	// contratos.setIdMesaContratacion(tipoFichaContrato
	// .getMesaContratacion().getIdMesaContratacion());
	// }
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getMesaContratacion().getDescripcionEs())) {
	// contratos.setDesMesaEs(tipoFichaContrato.getMesaContratacion()
	// .getDescripcionEs());
	// }
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getMesaContratacion().getDescripcionEu())) {
	// contratos.setDesMesaEu(tipoFichaContrato.getMesaContratacion()
	// .getDescripcionEu());
	// }
	// }
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getEntidadTramitadora())) {
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getEntidadTramitadora().getIdEntidadTramitadora())) {
	// contratos.setIdEntidadTram(tipoFichaContrato
	// .getEntidadTramitadora().getIdEntidadTramitadora());
	// }
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getEntidadTramitadora().getDescripcionEs())) {
	// contratos.setDesEntidadTramEs(tipoFichaContrato
	// .getEntidadTramitadora().getDescripcionEs());
	// }
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getEntidadTramitadora().getDescripcionEu())) {
	// contratos.setDesEntidadTramEu(tipoFichaContrato
	// .getEntidadTramitadora().getDescripcionEu());
	// }
	// }
	//
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato
	// .getValorEstimadoSinIva())) {
	//
	// contratos.setValEstSinIvaDouble(new BigDecimal(tipoFichaContrato
	// .getValorEstimadoSinIva().replace(",", ".")));
	//
	// contratos.setValEstSinIva(Ab18aUtils
	// .mostrarNumeroBigDecimal(tipoFichaContrato
	// .getValorEstimadoSinIva()));
	//
	// }
	//
	// Ab18aUtils.convertirObjetos3(tipoFichaContrato, contratos);
	//
	// }
	//
	// /**
	// * Convertir objetos3.
	// *
	// * @param tipoFichaContrato
	// * the tipo ficha contrato
	// * @param contratos
	// * the contratos
	// */
	// private static void convertirObjetos3(TipoFichaContrato
	// tipoFichaContrato,
	// Y4602S00 contratos) {
	// if (Ab18aUtils.notNullAndNotEmpty(tipoFichaContrato.getCpv())) {
	// if (tipoFichaContrato.getCpv().size() == 1) {
	// contratos.setCodCpv(tipoFichaContrato.getCpv().get(0).getIdCPV());
	// contratos.setDesCpvEs(tipoFichaContrato.getCpv().get(0).getDescripcionEs());
	// contratos.setDesCpvEu(tipoFichaContrato.getCpv().get(0).getDescripcionEu());
	// } else {
	// TipoCPV cpvPrincipal = obtenerCPVPrincipal(tipoFichaContrato.getCpv(),
	// tipoFichaContrato.getCpvPrincipal());
	// contratos.setCodCpv(cpvPrincipal.getIdCPV());
	// contratos.setDesCpvEs(cpvPrincipal.getDescripcionEs());
	// contratos.setDesCpvEu(cpvPrincipal.getDescripcionEu());
	// }
	// }
	// }
	//
	// /**
	// * Obtener firma email.
	// *
	// * @return the string
	// */
	// public static String obtenerFirmaEmail() {
	//
	// // firma de Gobierno Vasco
	// StringBuffer firmaEmail = new StringBuffer(Y46jConstantes.NUMERO_3000);
	// firmaEmail.append("<br/>");
	// firmaEmail.append("<br/>");
	// firmaEmail.append("<hr />");
	// firmaEmail.append("<br/><img src=\"cid:image4\">");
	// firmaEmail.append("</img><br/>");
	//
	// firmaEmail.append("<br/>");
	// firmaEmail
	// .append("<span style='color:orange;font-weight:bold;font-size:14px;face:Arial;'>");
	// firmaEmail.append(Y46jPropertiesManager.getProperty("NOMBREFIRMA"));
	// firmaEmail.append("</span>");
	// firmaEmail.append("<br/>");
	// firmaEmail
	// .append("<span style='color:#525252;font-weight:bold;font-size:13px;face:Arial;'>");
	// firmaEmail.append(Y46jPropertiesManager.getProperty("PUESTO"));
	// firmaEmail.append("</span>");
	// firmaEmail.append("<br/>");
	// firmaEmail.append("<span style='font-size:13px;face:Arial;'>");
	//
	// String nota = Y46jPropertiesManager.getProperty("NOTA");
	// String notaEU = Y46jPropertiesManager.getProperty("NOTAEU");
	// Y46jLog.debug("Y46jUtils", "obtenerFirmaEmail",
	// "Antes de obtener la nota..." + nota, 1);
	//
	// if (Ab18aUtils.notNullAndNotEmpty(nota)) {
	// firmaEmail.append(nota);
	// firmaEmail.append("<br/>");
	// }
	// if (Ab18aUtils.notNullAndNotEmpty(notaEU)) {
	// firmaEmail.append(notaEU);
	// firmaEmail.append("<br/>");
	// }
	//
	// Y46jLog.debug("Y46jUtils",
	// "obtenerFirmaEmail","despues de obtener la nota..." + notaEU, 1);
	//
	// firmaEmail.append("<a href ="
	// ).append(Y46jPropertiesManager.getProperty("EMAIL")).append(">"
	// ).append(Y46jPropertiesManager.getProperty("EMAIL")).append("</a>");
	// firmaEmail.append(Y46jPropertiesManager
	// .getProperty("CARACTER_SEPARADOR"));
	//
	// firmaEmail.append(Y46jPropertiesManager.getProperty("TELEFONO"));
	// firmaEmail.append("<br/>");
	// firmaEmail.append(Y46jPropertiesManager.getProperty("ENTIDAD"));
	// firmaEmail.append("<br/>");
	// firmaEmail.append(Y46jPropertiesManager.getProperty("DEPARTAMENTO"));
	// firmaEmail.append("<br/>");
	// firmaEmail.append(Y46jPropertiesManager.getProperty("PODER"));
	// firmaEmail.append("<br/>");
	// firmaEmail.append(Y46jPropertiesManager.getProperty("DIRECCION"));
	// firmaEmail.append(Y46jPropertiesManager
	// .getProperty("CARACTER_SEPARADOR"));
	// firmaEmail.append(Y46jPropertiesManager.getProperty("CP"));
	// firmaEmail.append(Y46jPropertiesManager
	// .getProperty("CARACTER_SEPARADOR"));
	// firmaEmail.append(Y46jPropertiesManager.getProperty("INFO"));
	// firmaEmail.append(Y46jPropertiesManager
	// .getProperty("CARACTER_SEPARADOR"));
	// firmaEmail.append("<br/>");
	// firmaEmail.append(Y46jPropertiesManager.getProperty("WEB"));
	// firmaEmail.append("<br/>");
	// firmaEmail.append("</span>");
	//
	// firmaEmail.append("<br/><img src=\"cid:image2\">");
	// firmaEmail.append("</img><br/>");
	// firmaEmail.append("<br/><img src=\"cid:image1\">");
	// firmaEmail.append("</img><br/>");
	// firmaEmail.append("<br/><a href='"
	// ).append(Y46jPropertiesManager.getProperty("WEBTURISMO")
	// ).append("'><img src=\"cid:image3\"></a>");
	// firmaEmail.append("</img><br/>");
	//
	// return firmaEmail.toString();
	// }
	//
	// /**
	// * Obtener datos formalizados.
	// *
	// * @param datosExcel
	// * the datos excel
	// * @param hojaFormalizados
	// * the hoja formalizados
	// * @param estiloTitulosGenerales
	// * the estilo titulos generales
	// * @param estiloTitulosLicitacion
	// * the estilo titulos licitacion
	// * @param estiloTitulosAccesoPublico
	// * the estilo titulos acceso publico
	// * @param estiloTitulosAdjudicacion
	// * the estilo titulos adjudicacion
	// * @param estiloCelda
	// * the estilo celda
	// * @param estiloFila
	// * the estilo fila
	// * @param columnsMaxSizeMap
	// * the columns max size map
	// */
	// public static void obtenerDatosFormalizados(
	// HashMap<Object, Object> datosExcel, HSSFSheet hojaFormalizados,
	// HSSFCellStyle estiloTitulosGenerales,
	// HSSFCellStyle estiloTitulosLicitacion,
	// HSSFCellStyle estiloTitulosAccesoPublico,
	// HSSFCellStyle estiloTitulosAdjudicacion, HSSFCellStyle estiloCelda,
	// HSSFCellStyle estiloFila, Map<Object, Object> columnsMaxSizeMap) {
	//
	// int rowCount = 0;
	// HSSFCell cell = null;
	//
	// // Obtenemos los títulos de las columnas
	//
	// Collection<Object> colTitulos = (Collection<Object>) datosExcel
	// .get("listaTitulosFormalizados");
	//
	// Map<Object, Object> listaTitulosMap = new HashMap<Object, Object>();
	//
	// Iterator<Object> it = colTitulos.iterator();
	// while (it.hasNext()) {
	// listaTitulosMap = (Map<Object, Object>) it.next();
	// }
	//
	// List<Object> listaTitulos = new ArrayList<Object>();
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // listaTitulosMap
	// Iterator<?> it2 = listaTitulosMap.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaTitulos"
	// while (it2.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it2.next();
	// String valor = (String) mapa.getValue();
	// listaTitulos.add(valor);
	// }
	//
	// // Obtenemos los datos de las columnas de la hoja Formalizados
	//
	// Collection<Object> colDatos = (Collection<Object>) datosExcel
	// .get("listaHashMapFormalizados");
	//
	// Map<Object, Object> listaHashMap = new HashMap<Object, Object>();
	// List<Object> listaDatos = new ArrayList<Object>();
	// List<Object> listaDatosC = new ArrayList<Object>();
	//
	// Iterator<Object> ite2 = colDatos.iterator();
	// while (ite2.hasNext()) {
	// listaHashMap = (Map<Object, Object>) ite2.next();
	// listaDatosC.add(listaHashMap);
	// }
	//
	// // Comenzamos con los datos de las filas
	// rowCount++;
	// String current = null;
	// int offset = 0;
	//
	// HSSFRow row = hojaFormalizados.createRow(rowCount);
	// // Dependiendo de la posición que ocupen los titulos les pongo un color
	// // u otro..
	// for (int i = 0; i < listaTitulos.size(); i++) {
	// cell = row.createCell((short) i);
	// cell.setCellValue((String) listaTitulos.get(i));
	// if (i <= Y46jConstantes.NUMERO_14) {
	// cell.setCellStyle(estiloTitulosGenerales);
	// } else if (i > Y46jConstantes.NUMERO_14
	// && i <= Y46jConstantes.NUMERO_16) {
	// cell.setCellStyle(estiloTitulosLicitacion);
	// } else if (i > Y46jConstantes.NUMERO_16
	// && i <= Y46jConstantes.NUMERO_21) {
	// cell.setCellStyle(estiloTitulosAdjudicacion);
	// } else {
	// cell.setCellStyle(estiloTitulosAccesoPublico);
	// }
	//
	// // Ajustar el tamaño de la columna a su contenido
	// hojaFormalizados.setColumnWidth((short) (i), Ab18aUtils
	// .getBestColSizeEnvios(listaTitulos, columnsMaxSizeMap, i,
	// (String) listaTitulos.get(i)));
	//
	// }
	//
	// rowCount++;
	//
	// for (int m = 0; m < listaDatosC.size(); m++) {
	// Map<Object, Object> contrato = (Map<Object, Object>) listaDatosC
	// .get(m);
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // contrato
	// Iterator<?> it3 = contrato.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaDatos"
	// while (it3.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it3.next();
	// String valor = (String) mapa.getValue();
	// listaDatos.add(valor);
	// }
	//
	// for (int i = 0; i < listaDatos.size(); i++) {
	//
	// row = hojaFormalizados.createRow(rowCount);
	// current = (String) listaDatos.get(i);
	// offset = 0;
	//
	// if (current != null) {
	//
	// String cellValue = "";
	// for (int j = 0; j < listaTitulos.size(); j++) {
	// cell = row.createCell((short) j);
	// cellValue = (String) listaDatos.get(j);
	// cell.setCellValue(cellValue);
	//
	// cell.setCellStyle(estiloCelda);
	//
	// if (offset > 0) {
	// hojaFormalizados.addMergedRegion(new Region(
	// rowCount, (short) j, rowCount + offset - 1,
	// (short) j));
	//
	// HSSFRow r = hojaFormalizados.getRow(rowCount
	// + offset - 1);
	// r.createCell((short) j).setCellStyle(estiloFila);
	// } else {
	// cell.setCellStyle(estiloFila);
	// }
	// // Ajustar el tamaño de la columna a su contenido
	// hojaFormalizados.setColumnWidth((short) (j), Ab18aUtils
	// .getBestColSizeEnvios(listaTitulos,
	// columnsMaxSizeMap, j, cellValue));
	// }
	//
	// listaDatos = (List<Object>) Ab18aUtils
	// .getObject(ArrayList.class.getName());
	// }
	//
	// if (offset > 0) {
	// rowCount += offset;
	// } else {
	// rowCount++;
	// }
	// }
	//
	// }
	// }
	//
	// /**
	// * Obtener datos desistidos.
	// *
	// * @param datosExcel
	// * the datos excel
	// * @param hojaDesistidos
	// * the hoja desistidos
	// * @param estiloTitulosGenerales
	// * the estilo titulos generales
	// * @param estiloTitulosLicitacion
	// * the estilo titulos licitacion
	// * @param estiloTitulosAccesoPublico
	// * the estilo titulos acceso publico
	// * @param estiloCelda
	// * the estilo celda
	// * @param estiloFila
	// * the estilo fila
	// * @param columnsMaxSizeMap
	// * the columns max size map
	// */
	// public static void obtenerDatosDesistidos(
	// HashMap<Object, Object> datosExcel, HSSFSheet hojaDesistidos,
	// HSSFCellStyle estiloTitulosGenerales,
	// HSSFCellStyle estiloTitulosLicitacion,
	// HSSFCellStyle estiloTitulosAccesoPublico,
	// HSSFCellStyle estiloCelda, HSSFCellStyle estiloFila,
	// Map<Object, Object> columnsMaxSizeMap) {
	//
	// int rowCountDes = 0;
	// HSSFCell cell = null;
	//
	// // Obtenemos los titulos del hoja de Desistidos
	// Collection<Object> colTitulosDes = (Collection<Object>) datosExcel
	// .get("listaTitulosDesistidos");
	//
	// Map<Object, Object> listaTitulosMapDes = new HashMap<Object, Object>();
	//
	// Iterator<Object> itDes = colTitulosDes.iterator();
	// while (itDes.hasNext()) {
	// listaTitulosMapDes = (Map<Object, Object>) itDes.next();
	// }
	//
	// List<Object> listaTitulosDes = new ArrayList<Object>();
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // listaTitulosMapDes
	// Iterator<?> it2Des = listaTitulosMapDes.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaTitulosDes"
	// while (it2Des.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it2Des.next();
	// String valor = (String) mapa.getValue();
	// listaTitulosDes.add(valor);
	// }
	//
	// // Obtenemos los datos de las columnas de la hoja de Desistimiento
	//
	// Collection<Object> colDatosDes = (Collection<Object>) datosExcel
	// .get("listaHashMapDesistidos");
	//
	// Map<Object, Object> listaHashMapDes = new HashMap<Object, Object>();
	// List<Object> listaDatosDes = new ArrayList<Object>();
	// List<Object> listaDatosCDes = new ArrayList<Object>();
	//
	// Iterator<Object> iteDes2 = colDatosDes.iterator();
	// while (iteDes2.hasNext()) {
	// listaHashMapDes = (Map<Object, Object>) iteDes2.next();
	// listaDatosCDes.add(listaHashMapDes);
	// }
	//
	// // Comenzamos con los datos de las filas
	// rowCountDes++;
	// String currentDes = null;
	// int offsetDes = 0;
	//
	// HSSFRow rowDes = hojaDesistidos.createRow(rowCountDes);
	// // Dependiendo de la posición que ocupen los titulos les pongo un color
	// // u otro..
	// for (int i = 0; i < listaTitulosDes.size(); i++) {
	// cell = rowDes.createCell((short) i);
	// cell.setCellValue((String) listaTitulosDes.get(i));
	// if (i <= Y46jConstantes.NUMERO_14) {
	// cell.setCellStyle(estiloTitulosGenerales);
	// } else if (i > Y46jConstantes.NUMERO_14
	// && i <= Y46jConstantes.NUMERO_16) {
	// cell.setCellStyle(estiloTitulosLicitacion);
	// } else {
	// cell.setCellStyle(estiloTitulosAccesoPublico);
	// }
	// // Ajustar el tamaño de la columna a su contenido
	// hojaDesistidos.setColumnWidth((short) (i), Ab18aUtils
	// .getBestColSizeEnvios(listaTitulosDes, columnsMaxSizeMap,
	// i, (String) listaTitulosDes.get(i)));
	// }
	// rowCountDes++;
	//
	// for (int m = 0; m < listaDatosCDes.size(); m++) {
	// Map<Object, Object> contrato = (Map<Object, Object>) listaDatosCDes
	// .get(m);
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // contrato
	// Iterator<?> it3 = contrato.entrySet().iterator();
	//
	// // Introducimos los valores en la lista "listaDatosCDes"
	// while (it3.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it3.next();
	// String valor = (String) mapa.getValue();
	// listaDatosDes.add(valor);
	// }
	//
	// for (int i = 0; i < listaDatosDes.size(); i++) {
	//
	// rowDes = hojaDesistidos.createRow(rowCountDes);
	// currentDes = (String) listaDatosDes.get(i);
	// offsetDes = 0;
	//
	// if (currentDes != null) {
	//
	// String cellValue = "";
	// for (int j = 0; j < listaTitulosDes.size(); j++) {
	// cell = rowDes.createCell((short) j);
	// cellValue = (String) listaDatosDes.get(j);
	// cell.setCellValue(cellValue);
	//
	// cell.setCellStyle(estiloCelda);
	//
	// if (offsetDes > 0) {
	// hojaDesistidos.addMergedRegion(new Region(
	// rowCountDes, (short) j, rowCountDes
	// + offsetDes - 1, (short) j));
	//
	// HSSFRow r = hojaDesistidos.getRow(rowCountDes
	// + offsetDes - 1);
	// r.createCell((short) j).setCellStyle(estiloFila);
	// } else {
	// cell.setCellStyle(estiloFila);
	// }
	// // Ajustar el tamaño de la columna a su contenido
	// hojaDesistidos.setColumnWidth((short) (j), Ab18aUtils
	// .getBestColSizeEnvios(listaTitulosDes,
	// columnsMaxSizeMap, j, cellValue));
	// }
	//
	// listaDatosDes = (List<Object>) Ab18aUtils
	// .getObject(ArrayList.class.getName());
	// }
	//
	// if (offsetDes > 0) {
	// rowCountDes += offsetDes;
	// } else {
	// rowCountDes++;
	// }
	// }
	//
	// }
	//
	// }
	//
	// /**
	// * Obtener datos ejecucion.
	// *
	// * @param datosExcel
	// * the datos excel
	// * @param hojaEjecucion
	// * the hoja ejecucion
	// * @param estiloTitulosGenerales
	// * the estilo titulos generales
	// * @param estiloTitulosLicitacion
	// * the estilo titulos licitacion
	// * @param estiloTitulosAccesoPublico
	// * the estilo titulos acceso publico
	// * @param estiloTitulosSujeto
	// * the estilo titulos sujeto
	// * @param estiloCelda
	// * the estilo celda
	// * @param estiloFila
	// * the estilo fila
	// * @param columnsMaxSizeMap
	// * the columns max size map
	// */
	// public static void obtenerDatosEjecucion(
	// HashMap<Object, Object> datosExcel, HSSFSheet hojaEjecucion,
	// HSSFCellStyle estiloTitulosGenerales,
	// HSSFCellStyle estiloTitulosLicitacion,
	// HSSFCellStyle estiloTitulosAccesoPublico,
	// HSSFCellStyle estiloTitulosSujeto, HSSFCellStyle estiloCelda,
	// HSSFCellStyle estiloFila, Map<Object, Object> columnsMaxSizeMap) {
	//
	// int rowCountEje = 0;
	// HSSFCell cell = null;
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "INICIO obtenerDatosEjecucion", 1);
	//
	// // Obtenemos los titulos del hoja de Ejecucion
	// Collection<Object> colTitulosEje = (Collection<Object>) datosExcel
	// .get("listaTitulosEjecucion");
	//
	// Map<Object, Object> listaTitulosMapEje = new HashMap<Object, Object>();
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Recoger titulos", 1);
	//
	// Iterator<Object> itEje = colTitulosEje.iterator();
	// while (itEje.hasNext()) {
	// listaTitulosMapEje = (Map<Object, Object>) itEje.next();
	// }
	//
	// List<Object> listaTitulosEje = new ArrayList<Object>();
	//
	// // Creamos un iterador que recorra las parejas key-value de
	// // listaTitulosMapEje
	// Iterator<?> it2Eje = listaTitulosMapEje.entrySet().iterator();
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes",
	// "Introducir valores en la lista 'listaTitulosEje'", 1);
	//
	// // Introducimos los valores en la lista "listaTitulosEje"
	// while (it2Eje.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it2Eje.next();
	// String valor = (String) mapa.getValue();
	// listaTitulosEje.add(valor);
	// }
	//
	// // Obtenemos los datos de las columnas de la hoja de Ejecución
	//
	// Collection<Object> colDatosEje = (Collection<Object>) datosExcel
	// .get("listaHashMapEjecucion");
	// Map<Object, Object> listaHashMapEje = new HashMap<Object, Object>();
	// List<Object> listaDatosEje = new ArrayList<Object>();
	// List<Object> listaDatosCEje = new ArrayList<Object>();
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes",
	// "Recoger datos de las columnas de la hoja de ejecuci�n", 1);
	//
	// Iterator<Object> iteEje2 = colDatosEje.iterator();
	// while (iteEje2.hasNext()) {
	// listaHashMapEje = (Map<Object, Object>) iteEje2.next();
	// if(listaHashMapEje!=null && listaHashMapEje.size()>0){
	// listaDatosCEje.add(listaHashMapEje);
	// }
	//
	// }
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Tama�o listaDatosCEje: " +
	// listaDatosCEje.size(), 1);
	//
	// // Comenzamos con los datos de las filas
	// rowCountEje++;
	// String currentEje = null;
	// int offsetEje = 0;
	//
	// HSSFRow rowDes = hojaEjecucion.createRow(rowCountEje);
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "Antes de poner color a titulos", 1);
	//
	// // Dependiendo de la posición que ocupen los titulos les pongo un color
	// // u otro..
	// for (int i = 0; i < listaTitulosEje.size(); i++) {
	// cell = rowDes.createCell((short) i);
	// cell.setCellValue((String) listaTitulosEje.get(i));
	// if (i <= Y46jConstantes.NUMERO_8) {
	// cell.setCellStyle(estiloTitulosGenerales);
	// } else if (i > Y46jConstantes.NUMERO_8
	// && i <= Y46jConstantes.NUMERO_16) {
	// cell.setCellStyle(estiloTitulosLicitacion);
	// } else if (i > Y46jConstantes.NUMERO_16
	// && i <= Y46jConstantes.NUMERO_21) {
	// cell.setCellStyle(estiloTitulosAccesoPublico);
	// } else {
	// cell.setCellStyle(estiloTitulosSujeto);
	// }
	// // Ajustar el tamaño de la columna a su contenido
	// hojaEjecucion.setColumnWidth((short) (i), Ab18aUtils
	// .getBestColSizeEnvios(listaTitulosEje, columnsMaxSizeMap,
	// i, (String) listaTitulosEje.get(i)));
	// }
	// rowCountEje++;
	//
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes",
	// "Antes de combinar parejas key-value de contrato", 1);
	//
	// for (int m = 0; m < listaDatosCEje.size(); m++) {
	// Map<Object, Object> contrato = (Map<Object, Object>) listaDatosCEje
	// .get(m);
	//
	// if(notEqualsEmpty(contrato)){
	// // Creamos un iterador que recorra las parejas key-value de
	// // contrato
	// Iterator<?> it3 = contrato.entrySet().iterator();
	//
	// listaDatosEje = (List<Object>) Ab18aUtils.getObject(ArrayList.class
	// .getName());
	//
	//
	// // Introducimos los valores en la lista "listaDatosCEje"
	// while (it3.hasNext()) {
	// Map.Entry mapa = (Map.Entry) it3.next();
	// String valor = (String) mapa.getValue();
	//
	// listaDatosEje.add(valor);
	//
	// }
	// int cont = 0;
	//
	// for (int i = 0; i < listaDatosEje.size(); i++) {
	// currentEje = (String) listaDatosEje.get(i);
	// if (currentEje == null) {
	// cont++;
	// }
	// }
	//
	//
	//
	// if (listaDatosEje.size() != cont) {
	//
	//
	//
	// for (int i = 0; i < listaDatosEje.size(); i++) {
	//
	// rowDes = hojaEjecucion.createRow(rowCountEje);
	// currentEje = (String) listaDatosEje.get(i);
	//
	// offsetEje = 0;
	//
	// if (currentEje != null ) {
	//
	//
	// String cellValue = "";
	// for (int j = 0; j < listaTitulosEje.size(); j++) {
	// cell = rowDes.createCell((short) j);
	//
	//
	// cellValue = (String) listaDatosEje.get(j);
	//
	// cell.setCellValue(cellValue);
	//
	// cell.setCellStyle(estiloCelda);
	//
	// if (offsetEje > 0) {
	//
	// hojaEjecucion.addMergedRegion(new Region(
	// rowCountEje, (short) j, rowCountEje
	// + offsetEje - 1, (short) j));
	//
	// HSSFRow r = hojaEjecucion.getRow(rowCountEje
	// + offsetEje - 1);
	// r.createCell((short) j)
	// .setCellStyle(estiloFila);
	// } else {
	// cell.setCellStyle(estiloFila);
	// }
	//
	// // Ajustar el tamaño de la columna a su contenido
	// hojaEjecucion.setColumnWidth((short) (j), Ab18aUtils
	// .getBestColSizeEnvios(listaTitulosEje,
	// columnsMaxSizeMap, j, cellValue));
	//
	// }
	//
	// if (listaDatosEje.size() <= listaTitulosEje.size()) {
	//
	//
	// listaDatosEje = (List<Object>) Ab18aUtils
	// .getObject(ArrayList.class.getName());
	//
	//
	// } else {
	//
	//
	// List<Object> listaDatosFin = listaDatosEje.subList(
	// listaTitulosEje.size(),
	// listaDatosEje.size());
	//
	// listaDatosEje = listaDatosFin;
	//
	// }
	//
	// }
	// if (offsetEje > 0) {
	// rowCountEje += offsetEje;
	// } else {
	// rowCountEje++;
	// }
	// }
	// }
	// }
	// }
	// Y46jLog.debug(Y46jGeneracionInformes.class.getName(),
	// "generarExcelListadoInformes", "FIN obtenerDatosEjecucion", 1);
	// }
	//
	// private static boolean notEqualsEmpty(Map<Object, Object> contrato) {
	// boolean result=false;
	// List<Object> list = new ArrayList<Object>(contrato.values());
	// for (Object s : list) {
	// if(s!=null && !s.equals("")){
	// result=true;
	// }
	// }
	// return result;
	// }
	//
	//
	// /**
	// * Formatear numero.
	// *
	// * @param numero
	// * the numero
	// * @return the string
	// */
	// private static String formatearNumeroEntero(Double numero) {
	//
	// if (numero == null) {
	// return null;
	// }
	//
	// DecimalFormatSymbols dsymbol = new DecimalFormatSymbols();
	// dsymbol.setGroupingSeparator('.');
	//
	// DecimalFormat df = new DecimalFormat();
	//
	// df.setMaximumFractionDigits(0);
	// df.setMinimumFractionDigits(0);
	// df.setMaximumIntegerDigits(Y46jConstantes.NUMERO_20);
	// df.setMinimumIntegerDigits(0);
	// df.setDecimalFormatSymbols(dsymbol);
	// return df.format(numero);
	// }
	// /**
	// * Mostrar numero double.
	// *
	// * @param numero
	// * the numero
	// * @return the string
	// */
	// private static String mostrarNumeroDouble(String numero) {
	// String numeroD = numero.replace(",", ".");
	// return Ab18aUtils.formatearNumero(Double.valueOf(numeroD));
	// }
	//
	// /**
	// * Formatear numero.
	// *
	// * @param numero
	// * the numero
	// * @return the string
	// */
	// private static String formatearNumero(Double numero) {
	//
	// if (numero == null) {
	// return null;
	// }
	//
	// DecimalFormatSymbols dsymbol = new DecimalFormatSymbols();
	// dsymbol.setDecimalSeparator(',');
	// dsymbol.setGroupingSeparator('.');
	//
	// DecimalFormat df = new DecimalFormat();
	//
	// df.setMaximumFractionDigits(2);
	// df.setMinimumFractionDigits(0);
	// df.setMaximumIntegerDigits(Y46jConstantes.NUMERO_16);
	// df.setMinimumIntegerDigits(0);
	// df.setDecimalFormatSymbols(dsymbol);
	// if (numero < 1) {
	// String num = numero.toString();
	// return num.replace(".", ",");
	// } else {
	// return df.format(numero);
	// }
	// }
	//
	// /**
	// * Formatear numero entero.
	// *
	// * @param numero
	// * the numero
	// * @return the string
	// */
	// public static String formatearNumeroEntero(Integer numero) {
	//
	// if (numero == null) {
	// return null;
	// }
	//
	// DecimalFormatSymbols dsymbol = new DecimalFormatSymbols();
	// dsymbol.setGroupingSeparator('.');
	//
	// DecimalFormat df = new DecimalFormat();
	//
	// df.setMaximumFractionDigits(0);
	// df.setMinimumFractionDigits(0);
	// df.setMaximumIntegerDigits(Y46jConstantes.NUMERO_20);
	// df.setMinimumIntegerDigits(0);
	// df.setDecimalFormatSymbols(dsymbol);
	// return df.format(numero);
	// }
	//
	// /**
	// * Tratar valor double.
	// *
	// * @param numeroDouble
	// * the numero double
	// * @param sinDecimales
	// * the sin decimales
	// * @return the string
	// */
	// private static String tratarValorDouble(String numeroDouble,
	// boolean sinDecimales) {
	// String numero = numeroDouble.replace('.', ',');
	// StringBuffer decimales = new StringBuffer();
	//
	// if (numero.indexOf(',') != -1) {
	// decimales.append((numero.split(","))[1]);
	// numero = (numero.split(","))[0];
	// if (decimales.length() == 1) {
	// decimales.append("0");
	// }
	// } else {
	// decimales.append("00");
	// }
	// StringBuffer numeroTratado = new StringBuffer();
	// StringBuffer numeroResultado = new StringBuffer();
	// StringBuffer numeroFin = new StringBuffer();
	// StringBuffer numeroFinal = new StringBuffer();
	// while (numero != "") {
	// if (numero.length() > Y46jConstantes.NUMERO_3) {
	//
	// numeroTratado = Ab18aUtils.crearStringBuffer();
	// numeroTratado.append(".");
	// numeroTratado.append(numero.substring(numero.length()
	// - Y46jConstantes.NUMERO_3, numero.length()));
	//
	// if (numeroFin.length() > 0) {
	// numeroTratado.append(numeroFin);
	// numeroFinal = numeroTratado;
	// numeroFin = numeroFinal;
	//
	// } else {
	// numeroFin.append(numeroTratado);
	// }
	//
	// numero = numero.substring(0, numero.length()
	// - Y46jConstantes.NUMERO_3);
	// } else {
	// numeroResultado.append(numero);
	// numeroResultado.append(numeroFin);
	// numero = "";
	// }
	// }
	// if (sinDecimales) {
	// return numeroResultado.toString();
	// }
	// return numeroResultado + "," + decimales;
	//
	// }
	//
	// public static String bigDecimalToStringRoundingHALF_EVEN(BigDecimal
	// numeroBigDecimal, int numDecimales){
	// DecimalFormatSymbols simbolos = new DecimalFormatSymbols();
	// simbolos.setDecimalSeparator('.');
	// DecimalFormat df = new DecimalFormat();
	// df.setDecimalFormatSymbols(simbolos);
	// df.setMinimumIntegerDigits(1);
	// df.setMaximumFractionDigits(numDecimales);
	// df.setMinimumFractionDigits(numDecimales);
	// df.setGroupingUsed(false);
	// return df.format(numeroBigDecimal);
	// }
	//
	// /**
	// * Crear string buffer.
	// *
	// * @return the string buffer
	// */
	// public static StringBuffer crearStringBuffer() {
	// return new StringBuffer();
	// }
	//
	// /**
	// * Maximo.
	// *
	// * @param a
	// * the a
	// * @param b
	// * the b
	// * @param c
	// * the c
	// * @return the int
	// */
	// public static int maximo(int a, int b, int c) {
	// int max = a;
	// if (b > max) {
	// max = b;
	// }
	// if (c > max) {
	// max = c;
	// }
	// return max;
	// }
	//
	// /**
	// * Clob to string.
	// *
	// * @param datoClob
	// * the dato clob
	// * @return the string
	// * @throws Y46jDBException
	// * the y46j db exception
	// */
	// public static String clobToString(Clob datoClob) throws Y46jDBException {
	// try {
	// BufferedReader br = new BufferedReader(
	// datoClob.getCharacterStream());
	// String buff;
	// StringBuffer strOut = new StringBuffer();
	// while ((buff = br.readLine()) != null) {
	// strOut.append(buff);
	// }
	// return strOut.toString();
	// } catch (Exception e) {
	// Y46jLog.error("", "clobToString",
	// "Se ha producido un error en clobToString", 1);
	// throw new Y46jDBException(Ab18aUtils.class.getName(),
	// "clobToString", e);
	//
	// }
	// }
	//
	//
	// /**
	// * Crear cells.
	// *
	// * @param hojaFormalizados
	// * the hoja formalizados
	// * @param hojaDesistidos
	// * the hoja desistidos
	// * @param hojaEjecucion
	// * the hoja ejecucion
	// * @param listaTitulosPrincipalesMap
	// * the lista titulos principales map
	// * @param estiloTituloGeneral
	// * the estilo titulo general
	// * @param estiloTituloLicitacion
	// * the estilo titulo licitacion
	// * @param estiloTituloAdjudicacion
	// * the estilo titulo adjudicacion
	// * @param estiloTituloAccesoPublico
	// * the estilo titulo acceso publico
	// * @param estiloTituloSujeto
	// * the estilo titulo sujeto
	// */
	// public static void crearCells(HSSFSheet hojaFormalizados,
	// HSSFSheet hojaDesistidos, HSSFSheet hojaEjecucion,
	// Map<Object, Object> listaTitulosPrincipalesMap,
	// HSSFCellStyle estiloTituloGeneral,
	// HSSFCellStyle estiloTituloLicitacion,
	// HSSFCellStyle estiloTituloAdjudicacion,
	// HSSFCellStyle estiloTituloAccesoPublico,
	// HSSFCellStyle estiloTituloSujeto,Integer tipoIndicador) {
	//
	// HSSFCell cell = null;
	// int rowCount = 0;
	// if(tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66){
	// // Creamos primera fila para los titulos Principales de FORMALIZADOS
	// HSSFRow rowTituloGeneral = hojaFormalizados.createRow(rowCount);
	// // Titulo Generales
	// cell = rowTituloGeneral.createCell((short) 0);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("0").toString());
	// cell.setCellStyle(estiloTituloGeneral);
	// hojaFormalizados.addMergedRegion(new Region(0, (short) 0, 0,
	// (short) Y46jConstantes.NUMERO_13));
	// // Titulo Licitacion
	// cell = rowTituloGeneral.createCell((short) Y46jConstantes.NUMERO_14);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("1").toString());
	// cell.setCellStyle(estiloTituloLicitacion);
	// hojaFormalizados.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_14, 0,
	// (short) Y46jConstantes.NUMERO_15));
	// // Titulo Adjudicación
	// cell = rowTituloGeneral.createCell((short) Y46jConstantes.NUMERO_16);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("2").toString());
	// cell.setCellStyle(estiloTituloAdjudicacion);
	// hojaFormalizados.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_16, 0,
	// (short) Y46jConstantes.NUMERO_20));
	// // Acceso Público-REVASCÓN
	// cell = rowTituloGeneral.createCell((short) Y46jConstantes.NUMERO_21);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("3").toString());
	// cell.setCellStyle(estiloTituloAccesoPublico);
	//
	// // Creamos primera fila para los titulos Principales de
	// // DESISTIDOS-DESIERTOS
	// HSSFRow rowTituloDesistidos = hojaDesistidos.createRow(rowCount);
	// // Titulo Generales
	// cell = rowTituloDesistidos.createCell((short) 0);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("0").toString());
	// cell.setCellStyle(estiloTituloGeneral);
	// hojaDesistidos.addMergedRegion(new Region(0, (short) 0, 0,
	// (short) Y46jConstantes.NUMERO_13));
	// // Titulo Desistimiento/Renuncia
	// cell = rowTituloDesistidos.createCell((short) Y46jConstantes.NUMERO_14);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("4").toString());
	// cell.setCellStyle(estiloTituloLicitacion);
	// hojaDesistidos.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_14, 0,
	// (short) Y46jConstantes.NUMERO_15));
	//
	// // Acceso Público-Perfil
	// cell = rowTituloDesistidos.createCell((short) Y46jConstantes.NUMERO_16);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("5").toString());
	// cell.setCellStyle(estiloTituloAccesoPublico);
	// }
	// // Creamos primera fila para los titulos Principales de
	// // EJECUCION
	// HSSFRow rowTituloEjecucion = hojaEjecucion.createRow(rowCount);
	// // Titulo Generales
	// cell = rowTituloEjecucion.createCell((short) 0);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("0").toString());
	// cell.setCellStyle(estiloTituloGeneral);
	// hojaEjecucion.addMergedRegion(new Region(0, (short) 0, 0,
	// (short) Y46jConstantes.NUMERO_7));
	// // Titulo Modificaciones del Objeto
	// cell = rowTituloEjecucion.createCell((short) Y46jConstantes.NUMERO_8);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("6").toString());
	// cell.setCellStyle(estiloTituloLicitacion);
	// hojaEjecucion.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_8, 0,
	// (short) Y46jConstantes.NUMERO_15));
	//
	// // Modificaciones del Plazo
	// cell = rowTituloEjecucion.createCell((short) Y46jConstantes.NUMERO_16);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("7").toString());
	// cell.setCellStyle(estiloTituloAccesoPublico);
	// hojaEjecucion.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_16, 0,
	// (short) Y46jConstantes.NUMERO_20));
	//
	// // Modificaciones del Sujeto
	// cell = rowTituloEjecucion.createCell((short) Y46jConstantes.NUMERO_21);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("8").toString());
	// cell.setCellStyle(estiloTituloSujeto);
	// if(tipoIndicador!=null && (
	// tipoIndicador.intValue()==com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_49_TVC
	// ||
	// tipoIndicador.intValue()==com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_50
	// ||
	// tipoIndicador.intValue()==com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66
	// )){
	// hojaEjecucion.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_21, 0,
	// (short) com.ejie.y46j.constantes.Y46jConstantes.NUMERO_25));
	// }else{
	// hojaEjecucion.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_21, 0,
	// (short) com.ejie.y46j.constantes.Y46jConstantes.NUMERO_24));
	// }
	//
	// }
	//
	//
	// /**
	// * Crear cells.
	// *
	// * @param hojaFormalizados
	// * the hoja formalizados
	// * @param hojaDesistidos
	// * the hoja desistidos
	// * @param hojaEjecucion
	// * the hoja ejecucion
	// * @param listaTitulosPrincipalesMap
	// * the lista titulos principales map
	// * @param estiloTituloGeneral
	// * the estilo titulo general
	// * @param estiloTituloLicitacion
	// * the estilo titulo licitacion
	// * @param estiloTituloAdjudicacion
	// * the estilo titulo adjudicacion
	// * @param estiloTituloAccesoPublico
	// * the estilo titulo acceso publico
	// * @param estiloTituloSujeto
	// * the estilo titulo sujeto
	// */
	// public static void crearCellsIndicadores(HSSFSheet hojaFormalizados,
	// HSSFSheet hojaDesistidos, HSSFSheet hojaEjecucion,
	// Map<Object, Object> listaTitulosPrincipalesMap,
	// HSSFCellStyle estiloTituloGeneral,
	// HSSFCellStyle estiloTituloLicitacion,
	// HSSFCellStyle estiloTituloAdjudicacion,
	// HSSFCellStyle estiloTituloAccesoPublico,
	// HSSFCellStyle estiloTituloSujeto,Integer tipoIndicador) {
	//
	// HSSFCell cell = null;
	// int rowCount = 0;
	// if(tipoIndicador!=null &&
	// tipoIndicador.intValue()!=com.ejie.y46j.constantes.Y46jConstantes.INDICADOR_ID_66){
	// // Creamos primera fila para los titulos Principales de FORMALIZADOS
	// HSSFRow rowTituloGeneral = hojaFormalizados.createRow(rowCount);
	// // Titulo Generales
	// cell = rowTituloGeneral.createCell((short) 0);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("0").toString());
	// cell.setCellStyle(estiloTituloGeneral);
	// hojaFormalizados.addMergedRegion(new Region(0, (short) 0, 0,
	// (short) Y46jConstantes.NUMERO_14));
	// // Titulo Licitacion
	// cell = rowTituloGeneral.createCell((short) Y46jConstantes.NUMERO_15);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("1").toString());
	// cell.setCellStyle(estiloTituloLicitacion);
	// hojaFormalizados.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_15, 0,
	// (short) Y46jConstantes.NUMERO_16));
	// // Titulo Adjudicación
	// cell = rowTituloGeneral.createCell((short) Y46jConstantes.NUMERO_17);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("2").toString());
	// cell.setCellStyle(estiloTituloAdjudicacion);
	// hojaFormalizados.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_17, 0,
	// (short) Y46jConstantes.NUMERO_21));
	// // Acceso Público-REVASCÓN
	// cell = rowTituloGeneral.createCell((short)
	// com.ejie.y46j.constantes.Y46jConstantes.NUMERO_22);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("3").toString());
	// cell.setCellStyle(estiloTituloAccesoPublico);
	//
	// // Creamos primera fila para los titulos Principales de
	// // DESISTIDOS-DESIERTOS
	// HSSFRow rowTituloDesistidos = hojaDesistidos.createRow(rowCount);
	// // Titulo Generales
	// cell = rowTituloDesistidos.createCell((short) 0);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("0").toString());
	// cell.setCellStyle(estiloTituloGeneral);
	// hojaDesistidos.addMergedRegion(new Region(0, (short) 0, 0,
	// (short) Y46jConstantes.NUMERO_14));
	// // Titulo Desistimiento/Renuncia
	// cell = rowTituloDesistidos.createCell((short) Y46jConstantes.NUMERO_15);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("4").toString());
	// cell.setCellStyle(estiloTituloLicitacion);
	// hojaDesistidos.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_15, 0,
	// (short) Y46jConstantes.NUMERO_16));
	//
	// // Acceso Público-Perfil
	// cell = rowTituloDesistidos.createCell((short) Y46jConstantes.NUMERO_17);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("5").toString());
	// cell.setCellStyle(estiloTituloAccesoPublico);
	// }
	// // Creamos primera fila para los titulos Principales de
	// // EJECUCION
	// HSSFRow rowTituloEjecucion = hojaEjecucion.createRow(rowCount);
	// // Titulo Generales
	// cell = rowTituloEjecucion.createCell((short) 0);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("0").toString());
	// cell.setCellStyle(estiloTituloGeneral);
	// hojaEjecucion.addMergedRegion(new Region(0, (short) 0, 0,
	// (short) Y46jConstantes.NUMERO_8));
	// // Titulo Modificaciones del Objeto
	// cell = rowTituloEjecucion.createCell((short) Y46jConstantes.NUMERO_9);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("6").toString());
	// cell.setCellStyle(estiloTituloLicitacion);
	// hojaEjecucion.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_9, 0,
	// (short) Y46jConstantes.NUMERO_16));
	//
	// // Modificaciones del Plazo
	// cell = rowTituloEjecucion.createCell((short) Y46jConstantes.NUMERO_17);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("7").toString());
	// cell.setCellStyle(estiloTituloAccesoPublico);
	// hojaEjecucion.addMergedRegion(new Region(0,
	// (short) Y46jConstantes.NUMERO_17, 0,
	// (short) Y46jConstantes.NUMERO_21));
	//
	// // Modificaciones del Sujeto
	// cell = rowTituloEjecucion.createCell((short)
	// com.ejie.y46j.constantes.Y46jConstantes.NUMERO_22);
	// cell.setCellValue(listaTitulosPrincipalesMap.get("8").toString());
	// cell.setCellStyle(estiloTituloSujeto);
	// hojaEjecucion.addMergedRegion(new Region(0,
	// (short) com.ejie.y46j.constantes.Y46jConstantes.NUMERO_22, 0,
	// (short) com.ejie.y46j.constantes.Y46jConstantes.NUMERO_26));
	//
	//
	// }
	// /**
	// * Crear integer.
	// *
	// * @param i
	// * the i
	// * @return the integer
	// */
	// public static Integer crearInteger(int i) {
	// return new Integer(i);
	// }
	//
	// /**
	// * Method 'filtrarTildesYMayMin'. Metodo que devuelve el filtro de tildes
	// y
	// * de Mayúsculas y minúsculas.
	// *
	// * @param campo
	// * , valor the campo, the valor
	// * @param valor
	// * the valor
	// * @return String
	// */
	//
	// public static String filtrarTildesYMayMin(final Object campo, Object
	// valor) {
	//
	// String campoString = String.valueOf(campo);
	// String valorString = String.valueOf(valor);
	//
	// String filtro = " AND (UPPER(TRANSLATE(TRIM(" + campoString + "),'"
	// + Y46jConstantes.CTE_VOCALES_SIMPLES + "','"
	// + Y46jConstantes.CTE_VOCALES_SINSIMPLES
	// + "')) LIKE UPPER(TRANSLATE(TRIM('%" + valorString.trim()
	// + "%'),'" + Y46jConstantes.CTE_VOCALES_SIMPLES + "','"
	// + Y46jConstantes.CTE_VOCALES_SINSIMPLES + "'))) ";
	//
	// return filtro;
	// }
	//
	// /**
	// * String2 document.
	// *
	// * @param textoXML
	// * the texto xml
	// * @return the document
	// */
	// public static Document string2Document(String textoXML) {
	//
	// Document document = null;
	//
	// try {
	//
	// DocumentBuilderFactory factory = null;
	// DocumentBuilder builder = null;
	//
	// factory = DocumentBuilderFactory.newInstance();
	// factory.setValidating(false);
	// factory.setIgnoringElementContentWhitespace(false);
	// builder = factory.newDocumentBuilder();
	// StringReader stringIn = new StringReader(textoXML);
	// document = builder.parse(new InputSource(stringIn));
	//
	// } catch (ParserConfigurationException pce) {
	// Y46jLog.error("Y46jUtils", "string2Document",
	// "Se ha producido un error al convertir el String a document: "
	// + pce, 1);
	//
	// } catch (IOException io) {
	// Y46jLog.error("Y46jUtils", "string2Document",
	// "Se ha producido un error al convertir el String a document: "
	// + io, 1);
	//
	// } catch (SAXException se) {
	// Y46jLog.error("Y46jUtils", "string2Document",
	// "Se ha producido un error al convertir el String a document: "
	// + se, 1);
	//
	// }
	//
	// return document;
	// }
	//
	// /**
	// * Transforma una clase Date a XMLGregorianCalendar
	// * @param fecha Fecha a transformar
	// * @return XMLGregorianCalendar Fecha transformada
	// */
	// public static XMLGregorianCalendar dateToXMLGregorianCalendar(Date
	// fecha){
	// GregorianCalendar calendar = new GregorianCalendar();
	// calendar.setTime(fecha);
	//
	// Y46jLog.debug(Ab18aUtils.class.getName(), "metodo", "111-1", 1);
	//
	// XMLGregorianCalendar fechaXML =
	// XMLGregorianCalendarImpl.createDate(
	// calendar.get(GregorianCalendar.YEAR),
	// calendar.get(GregorianCalendar.MONTH) + 1,
	// calendar.get(GregorianCalendar.DAY_OF_MONTH),
	// DatatypeConstants.FIELD_UNDEFINED);
	//
	// Y46jLog.debug(Ab18aUtils.class.getName(), "metodo", "111-1", 1);
	//
	// return fechaXML;
	// }
	//
	// /**
	// * To upper and normalize.
	// *
	// * @param campo
	// * the campo
	// * @return the string
	// */
	// public static String toUpperAndNormalize(String campo) {
	// // Cadena de caracteres original a sustituir.
	// final String original =
	// com.ejie.y46j.constantes.Y46jConstantes.CTE_VOCALES;
	// // Cadena de caracteres ASCII que reemplazar�n los originales.
	// final String ascii =
	// com.ejie.y46j.constantes.Y46jConstantes.CTE_VOCALES_SINTILDES;
	//
	// for (int i = 0; i < original.length(); i++) {
	// // Reemplazamos los caracteres especiales.
	// campo = campo.replace(original.charAt(i),
	// ascii.charAt(i));
	// }
	// return campo;
	//
	// }
	//
	//
	// /**
	// * Formatear numero.
	// *
	// * @param numero
	// * the numero
	// * @return the string
	// */
	// public static String formatearNumero(BigDecimal numero) {
	//
	// if (numero == null) {
	// return null;
	// }
	//
	// DecimalFormatSymbols dsymbol = new DecimalFormatSymbols();
	// dsymbol.setDecimalSeparator(',');
	// dsymbol.setGroupingSeparator('.');
	//
	// DecimalFormat df = new DecimalFormat();
	//
	// df.setMaximumFractionDigits(6);
	// df.setMinimumFractionDigits(0);
	// df.setMaximumIntegerDigits(Y46jConstantes.NUMERO_16);
	// df.setMinimumIntegerDigits(0);
	// df.setDecimalFormatSymbols(dsymbol);
	// if (numero.compareTo(BigDecimal.ONE) < 0) {
	// String num = numero.toString();
	// return num.replace(".", ",");
	// } else {
	// return df.format(numero);
	// }
	// }
	//
	// /**
	// * Formatear numero.
	// *
	// * @param numero
	// * the numero
	// * @return the string
	// */
	// public static String formatearNumeroEntero(BigDecimal numero) {
	//
	// if (numero == null) {
	// return null;
	// }
	//
	// DecimalFormatSymbols dsymbol = new DecimalFormatSymbols();
	// dsymbol.setGroupingSeparator('.');
	//
	// DecimalFormat df = new DecimalFormat();
	//
	// df.setMaximumFractionDigits(0);
	// df.setMinimumFractionDigits(0);
	// df.setMaximumIntegerDigits(Y46jConstantes.NUMERO_20);
	// df.setMinimumIntegerDigits(0);
	// df.setDecimalFormatSymbols(dsymbol);
	// return df.format(numero);
	// }
	//
	// /**
	// * Mostrar numero BigDecimal.
	// *
	// * @param numero
	// * the numero
	// * @return the string
	// */
	// public static String mostrarNumeroBigDecimal(String numero) {
	// String numeroD = numero.replace(",", ".");
	// return Ab18aUtils.formatearNumero(new BigDecimal(numeroD));
	// }
	//
	// /**
	// * Tratar valor BigDecimal.
	// *
	// * @param numeroBigDecimal
	// * the numero BigDecimal
	// * @param sinDecimales
	// * the sin decimales
	// * @return the string
	// */
	// public static String tratarValorBigDecimal(String numeroBigDecimal,
	// boolean sinDecimales) {
	//
	// String numero = numeroBigDecimal.replace('.', ',');
	// StringBuilder decimales = new StringBuilder();
	//
	// if (numero.indexOf(',') != -1) {
	// String numeroAux = numeroBigDecimal.replace('.', ',');
	// numero = (numeroAux.split(","))[0];
	// decimales.append(rightPagZeros((numeroAux.split(","))[1], 6));
	// } else {
	// decimales.append("000000");
	// }
	// StringBuilder numeroTratado = new StringBuilder();
	// StringBuilder numeroResultado = new StringBuilder();
	// StringBuilder numeroFin = new StringBuilder();
	// StringBuilder numeroFinal = new StringBuilder();
	// while (numero != "") {
	// if (numero.length() > Y46jConstantes.NUMERO_3) {
	//
	// numeroTratado = Ab18aUtils.crearStringBuilder();
	// numeroTratado.append(".");
	// numeroTratado.append(numero.substring(numero.length()
	// - Y46jConstantes.NUMERO_3, numero.length()));
	//
	// if (numeroFin.length() > 0) {
	// numeroTratado.append(numeroFin);
	// numeroFinal = numeroTratado;
	// numeroFin = numeroFinal;
	//
	// } else {
	// numeroFin.append(numeroTratado);
	// }
	//
	// numero = numero.substring(0, numero.length()
	// - Y46jConstantes.NUMERO_3);
	// } else {
	// numeroResultado.append(numero);
	// numeroResultado.append(numeroFin);
	// numero = "";
	// }
	// }
	// if (sinDecimales) {
	// return numeroResultado.toString();
	// }
	// return numeroResultado + "," + decimales;
	//
	// }
	//
	// /**
	// * Crear string buffer.
	// *
	// * @return the string buffer
	// */
	// public static StringBuilder crearStringBuilder() {
	// return new StringBuilder();
	// }
	//
	// public static String rightPagZeros(String s, int n) {
	// if (s == null) s = "";
	// return String.format("%-" + n + "s", s).replace(' ', '0');
	// }
	//
	// private static TipoCPV obtenerCPVPrincipal(List<TipoCPV> listaCPVs,
	// String principal) {
	//
	// TipoCPV cpvPrincipal = new TipoCPV();
	// for (TipoCPV cpv : listaCPVs) {
	// if (principal==null || "".equalsIgnoreCase(principal)) {
	// cpvPrincipal = cpv;
	// break;
	// } else if (principal != null &&
	// principal.equalsIgnoreCase(cpv.getIdCPV())) {
	// cpvPrincipal = cpv;
	// break;
	// }
	// }
	//
	// return cpvPrincipal;
	// }
}
